/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import org.jboss.dependency.plugins.AbstractScopeInfo;
import org.jboss.dependency.spi.ScopeInfo;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.Scope;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.osgi.framework.bundle.OSGiServiceState;

public class OSGiScopeInfo
extends AbstractScopeInfo {
    private OSGiServiceState serviceState;

    private OSGiScopeInfo(Object name, String className, OSGiServiceState serviceState) {
        super(name, className);
        this.serviceState = serviceState;
    }

    static ScopeInfo createScopeInfo(Object name, String className, Class<?> clazz, OSGiServiceState serviceState) {
        if (className == null && clazz != null) {
            className = clazz.getName();
        }
        OSGiScopeInfo result = new OSGiScopeInfo(name, className, serviceState);
        if (clazz != null) {
            ScopeKey key = result.getScope();
            key.addScope(new Scope(CommonLevels.CLASS, clazz));
        }
        return result;
    }

    public ScopeKey getScope() {
        ScopeKey key = super.getScope();
        Scope scope = key.getScope(CommonLevels.CLASS);
        if (scope == null) {
            return key;
        }
        Object qualifier = scope.getQualifier();
        if (qualifier instanceof Class) {
            return key;
        }
        Object service = this.serviceState.getTarget();
        if (service != null) {
            Class<?> clazz = service.getClass();
            key.addScope(new Scope(CommonLevels.CLASS, clazz));
        }
        return key;
    }
}

