/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.metadata.OSGiMetaData;
import org.jboss.osgi.framework.metadata.internal.OSGiManifestMetaData;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class OSGiSystemState
extends AbstractBundleState {
    private OSGiMetaData osgiMetaData;
    private Version version;

    public OSGiSystemState(OSGiBundleManager bundleManager) {
        super(bundleManager);
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(new Attributes.Name("Bundle-SymbolicName"), "system.bundle");
        this.osgiMetaData = new OSGiManifestMetaData(manifest);
    }

    public static OSGiSystemState assertBundleState(Bundle bundle) {
        if (!((bundle = AbstractBundleState.assertBundleState(bundle)) instanceof OSGiSystemState)) {
            throw new IllegalArgumentException("Not an OSGiSystemState: " + bundle);
        }
        return (OSGiSystemState)bundle;
    }

    @Override
    public OSGiMetaData getOSGiMetaData() {
        return this.osgiMetaData;
    }

    @Override
    public boolean isFragment() {
        return false;
    }

    @Override
    public boolean isPersistentlyStarted() {
        return false;
    }

    public long getBundleId() {
        return 0L;
    }

    public String getLocation() {
        return "System Bundle";
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        ClassLoaderDomain domain = this.getBundleManager().getClassLoaderDomain();
        return domain.loadClass(name);
    }

    public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
        return null;
    }

    public URL getEntry(String path) {
        return null;
    }

    public Enumeration getEntryPaths(String path) {
        return null;
    }

    public URL getResource(String name) {
        return ((Object)((Object)this)).getClass().getClassLoader().getResource(name);
    }

    public Enumeration getResources(String name) throws IOException {
        return ((Object)((Object)this)).getClass().getClassLoader().getResources(name);
    }

    public void start(int options) throws BundleException {
        this.createBundleContext();
    }

    public void stop(int options) throws BundleException {
        final OSGiBundleManager bundleManager = this.getBundleManager();
        bundleManager.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                bundleManager.stopFramework();
            }
        });
    }

    @Override
    public void update() throws BundleException {
        final OSGiBundleManager bundleManager = this.getBundleManager();
        bundleManager.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                bundleManager.restartFramework();
            }
        });
    }

    public void update(InputStream in) throws BundleException {
        throw new BundleException("The system bundle cannot be updated from a stream");
    }

    public void uninstall() throws BundleException {
        throw new BundleException("The system bundle cannot be uninstalled");
    }

    public Version getVersion() {
        if (this.version == null) {
            String versionstr = this.getOSGiMetaData().getBundleVersion();
            this.version = Version.parseVersion((String)versionstr);
        }
        return this.version;
    }
}

