/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.tracker.ContextTracker;
import org.jboss.dependency.spi.tracker.ContextTracking;
import org.jboss.deployers.structure.spi.DeploymentRegistry;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.dependency.AbstractKernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.qualifier.QualifierMatcher;
import org.jboss.kernel.spi.qualifier.QualifierMatchers;
import org.jboss.kernel.spi.qualifier.QualifierParser;
import org.jboss.logging.Logger;
import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
import org.jboss.metadata.spi.MutableMetaData;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.retrieval.MetaDataRetrievalFactory;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.bundle.ContextComparator;
import org.jboss.osgi.framework.bundle.ControllerContextHandle;
import org.jboss.osgi.framework.bundle.FilterParserAndMatcher;
import org.jboss.osgi.framework.bundle.GenericServiceReferenceWrapper;
import org.jboss.osgi.framework.bundle.InstanceMetaDataRetrievalFactory;
import org.jboss.osgi.framework.bundle.KernelDictionaryFactory;
import org.jboss.osgi.framework.bundle.MDRUtils;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.bundle.OSGiBundleState;
import org.jboss.osgi.framework.bundle.OSGiServiceState;
import org.jboss.osgi.framework.bundle.OSGiServiceStateDictionaryFactory;
import org.jboss.osgi.framework.bundle.OSGiSystemState;
import org.jboss.osgi.framework.plugins.FrameworkEventsPlugin;
import org.jboss.osgi.framework.plugins.ServiceManagerPlugin;
import org.jboss.osgi.framework.plugins.internal.AbstractPlugin;
import org.jboss.osgi.framework.util.KernelUtils;
import org.jboss.osgi.framework.util.NoFilter;
import org.jboss.osgi.framework.util.RemoveOnlyCollection;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.service.FindHook;
import org.osgi.framework.hooks.service.ListenerHook;

public class ServiceManagerPluginImpl
extends AbstractPlugin
implements ServiceManagerPlugin {
    final Logger log = Logger.getLogger(ServiceManagerPluginImpl.class);
    private Kernel kernel;
    private ContextTracker previousTracker;
    private DeploymentRegistry registry;
    private Map<ControllerContext, ServiceReference> srefCache = new WeakHashMap<ControllerContext, ServiceReference>();
    private boolean enableMDRUsage = true;

    public ServiceManagerPluginImpl(OSGiBundleManager bundleManager, DeploymentRegistry registry) {
        super(bundleManager);
        if (registry == null) {
            throw new IllegalArgumentException("Null deployment registry");
        }
        this.registry = registry;
    }

    public void setEnableMDRUsage(boolean mdrUsage) {
        this.enableMDRUsage = mdrUsage;
    }

    public void start() {
        this.kernel = this.getBundleManager().getKernel();
        if (this.enableMDRUsage) {
            this.applyMDRUsage(true);
        }
    }

    public void stop() {
        if (this.enableMDRUsage) {
            this.applyMDRUsage(false);
        }
    }

    @Override
    public ServiceReference[] getRegisteredServices(AbstractBundleState bundleState) {
        Set<ControllerContext> contexts = this.getRegisteredContexts(bundleState);
        if (contexts.isEmpty()) {
            return null;
        }
        HashSet<ServiceReference> result = new HashSet<ServiceReference>();
        for (ControllerContext context : contexts) {
            ServiceReference ref = this.getServiceReferenceForContext(context);
            if (ref == null) continue;
            result.add(ref);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new ServiceReference[result.size()]);
    }

    @Override
    public ServiceReference[] getServicesInUse(AbstractBundleState bundleState) {
        Set contexts = bundleState.getUsedContexts((Object)bundleState);
        if (contexts == null || contexts.isEmpty()) {
            return null;
        }
        ArrayList<ServiceReference> references = new ArrayList<ServiceReference>();
        for (ControllerContext context : contexts) {
            ServiceReference ref = this.getServiceReferenceForContext(context);
            if (ref == null) continue;
            references.add(ref);
        }
        if (references.isEmpty()) {
            return null;
        }
        return references.toArray(new ServiceReference[references.size()]);
    }

    @Override
    public Set<Bundle> getUsingBundles(OSGiServiceState serviceState) {
        ContextTracker contextTracker = serviceState.getContextTracker();
        Set users = contextTracker.getUsers((ControllerContext)serviceState);
        HashSet<Bundle> bundles = new HashSet<Bundle>();
        for (Object user : users) {
            AbstractBundleState abs = this.getBundleForUser(user);
            bundles.add(abs.getBundleInternal());
        }
        return bundles;
    }

    @Override
    public Object getService(AbstractBundleState bundleState, ServiceReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException("Null reference");
        }
        ControllerContextHandle handle = (ControllerContextHandle)reference;
        ControllerContext context = handle.getContext();
        if (KernelUtils.isUnregistered(context)) {
            return null;
        }
        ContextTracking ct = (ContextTracking)context;
        Object target = ct.getTarget((ContextTracker)bundleState);
        return target;
    }

    @Override
    public ServiceReference getServiceReference(AbstractBundleState bundle, String clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null clazz");
        }
        Collection<ServiceReference> srefs = this.getServiceReferencesInternal(bundle, clazz, null, true);
        if ((srefs = this.processFindHooks(bundle, clazz, null, true, srefs)).isEmpty()) {
            return null;
        }
        ArrayList<ServiceReference> list = new ArrayList<ServiceReference>(srefs);
        return list.get(list.size() - 1);
    }

    @Override
    public ServiceReference[] getServiceReferences(AbstractBundleState bundle, String clazz, String filterStr, boolean checkAssignable) throws InvalidSyntaxException {
        Filter filter = null;
        if (filterStr != null) {
            filter = FrameworkUtil.createFilter((String)filterStr);
        }
        Collection<ServiceReference> srefs = this.getServiceReferencesInternal(bundle, clazz, filter, checkAssignable);
        if ((srefs = this.processFindHooks(bundle, clazz, filterStr, checkAssignable, srefs)).isEmpty()) {
            return null;
        }
        return srefs.toArray(new ServiceReference[srefs.size()]);
    }

    private Collection<ServiceReference> processFindHooks(AbstractBundleState bundle, String clazz, String filterStr, boolean checkAssignable, Collection<ServiceReference> srefs) {
        BundleContext context = bundle.getBundleContext();
        List<ServiceReference> hookRefs = this.getServiceReferencesInternal(bundle, FindHook.class.getName(), null, true);
        if (context == null || hookRefs.isEmpty()) {
            return srefs;
        }
        if (clazz != null && clazz.startsWith(FindHook.class.getPackage().getName())) {
            return srefs;
        }
        ArrayList<ServiceReference> sortedHookRefs = new ArrayList<ServiceReference>(hookRefs);
        Collections.reverse(sortedHookRefs);
        srefs = new RemoveOnlyCollection<ServiceReference>(srefs);
        ArrayList<FindHook> hooks = new ArrayList<FindHook>();
        for (ServiceReference hookRef : sortedHookRefs) {
            hooks.add((FindHook)context.getService(hookRef));
        }
        for (FindHook hook : hooks) {
            try {
                hook.find(context, clazz, filterStr, !checkAssignable, srefs);
            }
            catch (Exception ex) {
                this.log.warn((Object)("Error while calling FindHook: " + hook), (Throwable)ex);
            }
        }
        return srefs;
    }

    @Override
    public OSGiServiceState registerService(AbstractBundleState bundleState, String[] clazzes, Object service, Dictionary properties) {
        Collection<ListenerHook.ListenerInfo> listenerInfos = null;
        if (service instanceof ListenerHook) {
            FrameworkEventsPlugin eventsPlugin = this.getPlugin(FrameworkEventsPlugin.class);
            listenerInfos = eventsPlugin.getServiceListenerInfos(null);
        }
        OSGiServiceState result = new OSGiServiceState(bundleState, clazzes, service, properties);
        result.internalRegister();
        try {
            KernelController controller = this.kernel.getController();
            controller.install((ControllerContext)result);
        }
        catch (Throwable t) {
            this.getBundleManager().fireError(bundleState, "installing service to MC in", t);
            throw new RuntimeException(t);
        }
        if (bundleState instanceof OSGiBundleState) {
            this.putContext((ControllerContext)result, ((OSGiBundleState)bundleState).getDeploymentUnit());
        }
        if (service instanceof ListenerHook) {
            ListenerHook listenerHook = (ListenerHook)service;
            listenerHook.added(listenerInfos);
        }
        FrameworkEventsPlugin eventsPlugin = this.getPlugin(FrameworkEventsPlugin.class);
        eventsPlugin.fireServiceEvent(bundleState, 1, result);
        return result;
    }

    @Override
    public void unregisterService(OSGiServiceState serviceState) {
        AbstractBundleState bundleState = serviceState.getBundleState();
        FrameworkEventsPlugin plugin = this.getPlugin(FrameworkEventsPlugin.class);
        plugin.fireServiceEvent(bundleState, 4, serviceState);
        this.internalUnregister(serviceState);
        if (bundleState instanceof OSGiBundleState) {
            this.removeContext((ControllerContext)serviceState, ((OSGiBundleState)bundleState).getDeploymentUnit());
        }
        KernelController controller = this.kernel.getController();
        controller.uninstall(serviceState.getName());
    }

    private void internalUnregister(OSGiServiceState serviceState) {
        Set users;
        ContextTracker ct = serviceState.getContextTracker();
        if (ct != null && !(users = ct.getUsers((ControllerContext)serviceState)).isEmpty()) {
            HashSet<AbstractBundleState> used = new HashSet<AbstractBundleState>();
            for (Object user : users) {
                AbstractBundleState using = this.getBundleForUser(user);
                if (!used.add(using)) continue;
                for (int count = ct.getUsedByCount((ControllerContext)serviceState, (Object)using); count > 0; --count) {
                    using.ungetContext((ControllerContext)serviceState);
                }
            }
        }
        serviceState.clearTarget();
    }

    @Override
    public boolean ungetService(AbstractBundleState bundleState, ServiceReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException("Null reference");
        }
        ControllerContextHandle serviceReference = (ControllerContextHandle)reference;
        ControllerContext context = serviceReference.getContext();
        if (KernelUtils.isUnregistered(context)) {
            return false;
        }
        return bundleState.removeContextInUse(context);
    }

    @Override
    public void unregisterServices(AbstractBundleState bundleState) {
        this.unregisterContexts(bundleState);
    }

    private void applyMDRUsage(boolean register) {
        MutableMetaDataRepository repository = this.kernel.getMetaDataRepository().getMetaDataRepository();
        MetaDataRetrieval retrieval = repository.getMetaDataRetrieval(ScopeKey.DEFAULT_SCOPE);
        if (register && retrieval == null) {
            retrieval = new MemoryMetaDataLoader(ScopeKey.DEFAULT_SCOPE);
            repository.addMetaDataRetrieval(retrieval);
        }
        if (retrieval != null && retrieval instanceof MutableMetaData) {
            MutableMetaData mmd = (MutableMetaData)retrieval;
            if (register) {
                OSGiSystemState systemBundle = this.getBundleManager().getSystemBundle();
                this.previousTracker = (ContextTracker)mmd.addMetaData((Object)systemBundle, ContextTracker.class);
            } else if (this.previousTracker == null) {
                mmd.removeMetaData(ContextTracker.class);
                if (retrieval.isEmpty()) {
                    repository.removeMetaDataRetrieval(retrieval.getScope());
                }
            } else {
                mmd.addMetaData((Object)this.previousTracker, ContextTracker.class);
            }
        }
        FilterParserAndMatcher fpm = FilterParserAndMatcher.INSTANCE;
        QualifierMatchers matchers = QualifierMatchers.getInstance();
        if (register) {
            matchers.addParser((QualifierParser)fpm);
            matchers.addMatcher((QualifierMatcher)fpm);
            MetaDataRetrievalFactory mdrFactory = this.getMetaDataRetrievalFactory();
            repository.addMetaDataRetrievalFactory(CommonLevels.INSTANCE, mdrFactory);
        } else {
            repository.removeMetaDataRetrievalFactory(CommonLevels.INSTANCE);
            matchers.removeParser(fpm.getHandledContent());
            matchers.removeMatcher(fpm.getHandledType());
        }
    }

    private MetaDataRetrievalFactory getMetaDataRetrievalFactory() {
        InstanceMetaDataRetrievalFactory imdrf = new InstanceMetaDataRetrievalFactory(this.kernel);
        imdrf.addFactory(new OSGiServiceStateDictionaryFactory());
        imdrf.addFactory(new KernelDictionaryFactory(this.kernel.getConfigurator()));
        InstanceMetaDataRetrievalFactory mdrFactory = imdrf;
        return mdrFactory;
    }

    private List<ServiceReference> getServiceReferencesInternal(AbstractBundleState targetBundle, String className, Filter filter, boolean checkAssignable) {
        KernelController controller;
        ArrayList contexts;
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)("getServiceReferences(" + (Object)((Object)targetBundle) + "," + className + "," + filter + "," + checkAssignable + ")"));
        }
        if ((contexts = new ArrayList((controller = this.kernel.getController()).getContextsByState(ControllerState.INSTALLED))) == null || contexts.isEmpty()) {
            if (trace) {
                this.log.trace((Object)"Cannot get service references, no contexts found");
            }
            return Collections.emptyList();
        }
        if (filter == null) {
            filter = NoFilter.INSTANCE;
        }
        if (targetBundle.getBundleId() == 0L) {
            checkAssignable = false;
        }
        if (trace) {
            this.log.trace((Object)("Considered contexts: : " + contexts.size()));
        }
        Iterator iterator = contexts.iterator();
        while (iterator.hasNext()) {
            ControllerContext context = (ControllerContext)iterator.next();
            ServiceReference sref = this.getServiceReferenceForContext(context);
            if (sref == null || !this.hasPermission(context) || !filter.match(sref)) {
                iterator.remove();
                continue;
            }
            String[] classNames = (String[])sref.getProperty("objectClass");
            if (className != null && !Arrays.asList(classNames).contains(className)) {
                iterator.remove();
                continue;
            }
            AbstractBundleState sourceBundle = this.getBundleForContext(context);
            if (!checkAssignable || MDRUtils.isAssignableTo(context, sourceBundle, targetBundle, classNames)) continue;
            if (trace) {
                this.log.trace((Object)("Remove context, not assignable: " + context));
            }
            iterator.remove();
        }
        if (trace) {
            this.log.trace((Object)("Remaining contexts: : " + contexts.size()));
        }
        ArrayList sorted = new ArrayList(contexts);
        Collections.sort(sorted, ContextComparator.getInstance());
        ArrayList<ServiceReference> result = new ArrayList<ServiceReference>();
        for (ControllerContext context : sorted) {
            ServiceReference sref = this.getServiceReferenceForContext(context);
            if (trace) {
                this.log.trace((Object)("Found, ServiceReference: " + sref));
            }
            result.add(sref);
        }
        return result;
    }

    private ServiceReference getServiceReferenceForContext(ControllerContext context) {
        if (context instanceof OSGiServiceState) {
            OSGiServiceState service = (OSGiServiceState)context;
            return service.hasPermission() ? service.getReferenceInternal() : null;
        }
        if (context instanceof AbstractKernelControllerContext) {
            ServiceReference sref = this.srefCache.get(context);
            if (sref == null) {
                AbstractBundleState bundleState = this.getBundleForContext(context);
                sref = new GenericServiceReferenceWrapper(bundleState, (AbstractKernelControllerContext)context);
                this.srefCache.put(context, sref);
            }
            return sref;
        }
        return null;
    }

    private boolean hasPermission(ControllerContext context) {
        if (context instanceof OSGiServiceState) {
            OSGiServiceState serviceState = (OSGiServiceState)context;
            return serviceState.hasPermission();
        }
        return true;
    }

    private DeploymentUnit putContext(ControllerContext context, DeploymentUnit unit) {
        return this.registry.putContext(context, unit);
    }

    private DeploymentUnit removeContext(ControllerContext context, DeploymentUnit unit) {
        return this.registry.removeContext(context, unit);
    }

    private Set<ControllerContext> getRegisteredContexts(AbstractBundleState bundleState) {
        if (!(bundleState instanceof OSGiBundleState)) {
            return Collections.emptySet();
        }
        DeploymentUnit unit = ((OSGiBundleState)bundleState).getDeploymentUnit();
        return this.registry.getContexts(unit);
    }

    private void unregisterContexts(AbstractBundleState bundleState) {
        if (bundleState instanceof OSGiBundleState) {
            DeploymentUnit unit = ((OSGiBundleState)bundleState).getDeploymentUnit();
            Set contexts = this.registry.getContexts(unit);
            for (ControllerContext context : contexts) {
                if (!(context instanceof ServiceRegistration)) continue;
                ServiceRegistration service = (ServiceRegistration)context;
                service.unregister();
            }
        }
    }

    @Override
    public AbstractBundleState getBundleForUser(Object user) {
        if (user instanceof AbstractBundleState) {
            return (AbstractBundleState)((Object)user);
        }
        if (user instanceof ControllerContext) {
            return this.getBundleForContext((ControllerContext)user);
        }
        throw new IllegalArgumentException("Unknown tracker type: " + user);
    }

    @Override
    public AbstractBundleState getBundleForContext(ControllerContext context) {
        if (context instanceof OSGiServiceState) {
            OSGiServiceState service = (OSGiServiceState)context;
            return service.getBundleState();
        }
        OSGiBundleManager bundleManager = this.getBundleManager();
        DeploymentUnit unit = this.registry.getDeployment(context);
        if (unit != null) {
            AbstractBundleState bundleState = (AbstractBundleState)((Object)unit.getAttachment(AbstractBundleState.class));
            return bundleState;
        }
        return bundleManager.getSystemBundle();
    }
}

