/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.classloading;

import java.util.Map;
import org.jboss.classloading.plugins.metadata.ModuleRequirement;
import org.jboss.classloading.spi.version.VersionRange;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.classloading.OSGiRequirement;
import org.jboss.osgi.framework.metadata.ParameterizedAttribute;

abstract class OSGiBundleRequirement
extends ModuleRequirement
implements OSGiRequirement {
    private static final long serialVersionUID = 1L;
    private AbstractBundleState bundleState;
    private ParameterizedAttribute metadata;

    OSGiBundleRequirement(AbstractBundleState bundleState, String name, VersionRange versionRange, ParameterizedAttribute metadata) {
        super(name, versionRange);
        if (bundleState == null) {
            throw new IllegalArgumentException("Null bundleState");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("Null metadata");
        }
        this.bundleState = bundleState;
        this.metadata = metadata;
    }

    @Override
    public AbstractBundleState getBundleState() {
        return this.bundleState;
    }

    public ParameterizedAttribute getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof OSGiBundleRequirement)) {
            return false;
        }
        return super.equals(obj);
    }

    protected void toString(StringBuffer buffer) {
        super.toString(buffer);
        Map attributes = this.getMetadata().getAttributes();
        if (attributes != null && !attributes.isEmpty()) {
            buffer.append("," + attributes);
        }
    }
}

