/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.classloading;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.classloader.spi.NativeLibraryProvider;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.classloading.spi.vfs.policy.VFSClassLoaderPolicy;
import org.jboss.classloading.spi.vfs.policy.VirtualFileInfo;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.bundle.DeployedBundleState;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.bundle.OSGiBundleState;
import org.jboss.osgi.framework.classloading.OSGiClassLoadingMetaData;
import org.jboss.osgi.framework.classloading.OSGiModule;
import org.jboss.osgi.framework.metadata.NativeLibrary;
import org.jboss.osgi.framework.metadata.NativeLibraryMetaData;
import org.jboss.osgi.framework.plugins.BundleStoragePlugin;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;
import org.jboss.vfs.VFSUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;

public class OSGiClassLoaderPolicy
extends VFSClassLoaderPolicy
implements BundleReference {
    private static final Logger log = Logger.getLogger(OSGiClassLoaderPolicy.class);
    private AbstractBundleState bundleState;
    private List<org.jboss.vfs.VirtualFile> fragments;

    public OSGiClassLoaderPolicy(AbstractBundleState bundleState, org.jboss.vfs.VirtualFile[] roots) {
        super(roots);
        if (bundleState == null) {
            throw new IllegalArgumentException("Null bundleState");
        }
        this.bundleState = bundleState;
        if (bundleState instanceof DeployedBundleState) {
            DeployedBundleState depBundleState = (DeployedBundleState)bundleState;
            DeploymentUnit unit = depBundleState.getDeploymentUnit();
            Module module = (Module)unit.getAttachment(Module.class);
            if (!(module instanceof OSGiModule)) {
                throw new IllegalStateException("Not an instance of OSGiModule: " + module);
            }
            OSGiModule osgiModule = (OSGiModule)module;
            String[] packageNames = osgiModule.getPackageNames();
            this.setExportedPackages(packageNames);
            this.setIncluded(osgiModule.getIncluded());
            this.setExcluded(osgiModule.getExcluded());
            this.setExcludedExport(osgiModule.getExcludedExport());
            this.setExportAll(osgiModule.getExportAll());
            this.setImportAll(osgiModule.isImportAll());
            this.setCacheable(osgiModule.isCacheable());
            this.setBlackListable(osgiModule.isBlackListable());
            this.setDelegates(osgiModule.getDelegates());
            this.processNativeLibraryMetaData(depBundleState);
        }
    }

    public Bundle getBundle() {
        return this.bundleState.getBundle();
    }

    public String getName() {
        return this.bundleState.getCanonicalName();
    }

    private void processNativeLibraryMetaData(AbstractBundleState absBundleState) {
        if (!(absBundleState instanceof OSGiBundleState)) {
            return;
        }
        OSGiBundleState bundleState = (OSGiBundleState)absBundleState;
        DeploymentUnit unit = bundleState.getDeploymentUnit();
        ClassLoadingMetaData clMetaData = (ClassLoadingMetaData)unit.getAttachment(ClassLoadingMetaData.class);
        if (!(clMetaData instanceof OSGiClassLoadingMetaData)) {
            return;
        }
        OSGiClassLoadingMetaData classLoadingMetaData = (OSGiClassLoadingMetaData)clMetaData;
        NativeLibraryMetaData libMetaData = classLoadingMetaData.getNativeLibraries();
        if (libMetaData == null || libMetaData.getNativeLibraries() == null) {
            return;
        }
        for (NativeLibrary library : libMetaData.getNativeLibraries()) {
            String libpath = library.getLibraryPath();
            String libfile = new File(libpath).getName();
            String libname = libfile.substring(0, libfile.lastIndexOf(46));
            OSGiNativeLibraryProvider libProvider = new OSGiNativeLibraryProvider(bundleState, libname, libpath);
            this.addNativeLibrary(libProvider);
            if (!libname.startsWith("lib")) continue;
            libname = libname.substring(3);
            libProvider = new OSGiNativeLibraryProvider(bundleState, libname, libpath);
            this.addNativeLibrary(libProvider);
        }
    }

    public void attachFragment(org.jboss.vfs.VirtualFile fragRoot) {
        if (fragRoot == null) {
            throw new IllegalArgumentException("Null fragment file");
        }
        if (this.fragments == null) {
            this.fragments = new CopyOnWriteArrayList<org.jboss.vfs.VirtualFile>();
        }
        log.debug((Object)("attachFragment: " + fragRoot));
        this.fragments.add(fragRoot);
    }

    public boolean detachFragment(org.jboss.vfs.VirtualFile fragRoot) {
        if (fragRoot == null) {
            throw new IllegalArgumentException("Null fragment file");
        }
        if (this.fragments == null) {
            return false;
        }
        log.debug((Object)("detachFragment: " + fragRoot));
        return this.fragments.remove(fragRoot);
    }

    public org.jboss.vfs.VirtualFile[] getFragmentRoots() {
        if (this.fragments == null) {
            return null;
        }
        org.jboss.vfs.VirtualFile[] retarr = new org.jboss.vfs.VirtualFile[this.fragments.size()];
        this.fragments.toArray(retarr);
        return retarr;
    }

    protected VirtualFileInfo findVirtualFileInfo(String path) {
        VirtualFileInfo result = super.findVirtualFileInfo(path);
        if (result == null && this.fragments != null) {
            for (org.jboss.vfs.VirtualFile root : this.fragments) {
                try {
                    org.jboss.vfs.VirtualFile file = root.getChild(path);
                    if (file == null) continue;
                    result = new VirtualFileInfo(file, root);
                    break;
                }
                catch (Exception ignored) {
                }
            }
        }
        return result;
    }

    static class OSGiNativeLibraryProvider
    implements NativeLibraryProvider {
        private OSGiBundleState bundleState;
        private String libpath;
        private String libname;
        private File libraryFile;

        OSGiNativeLibraryProvider(OSGiBundleState bundleState, String libname, String libpath) {
            this.bundleState = bundleState;
            this.libpath = libpath;
            this.libname = libname;
            URL entryURL = bundleState.getEntry(libpath);
            if (entryURL == null) {
                throw new IllegalStateException("Cannot find native library: " + libpath);
            }
        }

        public String getLibraryName() {
            return this.libname;
        }

        public String getLibraryPath() {
            return this.libpath;
        }

        public File getLibraryLocation() throws IOException {
            if (this.libraryFile == null) {
                org.jboss.vfs.VirtualFile root = (org.jboss.vfs.VirtualFile)AbstractVFS.adapt((VirtualFile)this.bundleState.getRoot());
                org.jboss.vfs.VirtualFile fileSource = root.getChild(this.libpath);
                this.libraryFile = this.getUniqueLibraryFile(this.bundleState, this.libpath);
                this.libraryFile.deleteOnExit();
                FileOutputStream fos = new FileOutputStream(this.libraryFile);
                VFSUtils.copyStream((InputStream)fileSource.openStream(), (OutputStream)fos);
                fos.close();
            }
            return this.libraryFile;
        }

        private File getUniqueLibraryFile(AbstractBundleState bundleState, String libpath) {
            OSGiBundleManager bundleManager = bundleState.getBundleManager();
            String timestamp = new SimpleDateFormat("-yyyyMMdd-HHmmssSSS").format(new Date(bundleState.getLastModified()));
            String uniquePath = new StringBuffer(libpath).insert(libpath.lastIndexOf("."), timestamp).toString();
            BundleStoragePlugin plugin = bundleManager.getPlugin(BundleStoragePlugin.class);
            return plugin.getDataFile(bundleState, uniquePath);
        }
    }
}

