/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.classloading;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.osgi.framework.metadata.NativeLibraryMetaData;
import org.jboss.osgi.framework.metadata.Parameter;
import org.jboss.osgi.framework.metadata.ParameterizedAttribute;
import org.jboss.osgi.framework.metadata.internal.AbstractVersionRange;

public class OSGiClassLoadingMetaData
extends ClassLoadingMetaData {
    private static final long serialVersionUID = 1L;
    private FragmentHostMetaData fragmentHost;
    private List<OSGiClassLoadingMetaData> attachedFragments = new ArrayList<OSGiClassLoadingMetaData>();
    private NativeLibraryMetaData libraries = new NativeLibraryMetaData();

    public FragmentHostMetaData getFragmentHost() {
        return this.fragmentHost;
    }

    public void setFragmentHost(FragmentHostMetaData fragmentHost) {
        this.fragmentHost = fragmentHost;
    }

    public List<OSGiClassLoadingMetaData> getAttachedClassLoadingMetaData() {
        return Collections.unmodifiableList(this.attachedFragments);
    }

    public void attachClassLoadingMetaData(OSGiClassLoadingMetaData fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException("Null fragment");
        }
        if (fragment.getFragmentHost() == null) {
            throw new IllegalArgumentException("Not a fragment: " + (Object)((Object)fragment));
        }
        if (this.getFragmentHost() != null) {
            throw new IllegalArgumentException("Cannot attach a fragment to a fragment: " + (Object)((Object)fragment));
        }
        this.attachedFragments.add(fragment);
    }

    public NativeLibraryMetaData getNativeLibraries() {
        return this.libraries;
    }

    public void setNativeLibraries(NativeLibraryMetaData nativeLibraries) {
        if (nativeLibraries == null) {
            throw new IllegalArgumentException("Null libraries");
        }
        this.libraries = nativeLibraries;
    }

    public static class FragmentHostMetaData {
        private String symbolicName;
        private AbstractVersionRange versionRange;
        private ParameterizedAttribute metadata;
        private String extension;

        public FragmentHostMetaData(ParameterizedAttribute metadata) {
            Parameter extensionDirective;
            if (metadata == null) {
                throw new IllegalArgumentException("Null metadata");
            }
            this.metadata = metadata;
            this.symbolicName = metadata.getAttribute();
            String versionStr = (String)metadata.getAttributeValue("bundle-version", String.class);
            if (versionStr != null) {
                this.versionRange = AbstractVersionRange.valueOf((String)versionStr);
            }
            if ((extensionDirective = metadata.getDirective("extension")) != null) {
                this.extension = (String)extensionDirective.getValue();
            }
        }

        public ParameterizedAttribute getMetadata() {
            return this.metadata;
        }

        public String getSymbolicName() {
            return this.symbolicName;
        }

        public AbstractVersionRange getVersionRange() {
            return this.versionRange;
        }

        public String getExtension() {
            return this.extension;
        }
    }
}

