/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.classloading;

import java.util.List;
import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.plugins.classloader.VFSDeploymentClassLoaderPolicyModule;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.classloading.OSGiClassLoaderPolicy;
import org.jboss.vfs.VirtualFile;

public class OSGiModule
extends VFSDeploymentClassLoaderPolicyModule {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(OSGiModule.class);

    public OSGiModule(DeploymentUnit unit, ClassLoadingMetaData metaData) {
        super(unit);
        if (log.isTraceEnabled()) {
            log.trace((Object)("new OSGiModule\n  " + unit + "\n  " + metaData));
        }
    }

    public ClassLoaderPolicy createClassLoaderPolicy() {
        VFSDeploymentUnit unit = (VFSDeploymentUnit)this.getDeploymentUnit();
        return this.createClassLoaderPolicyInternal(unit);
    }

    ClassLoaderPolicy createClassLoaderPolicyInternal(VFSDeploymentUnit unit) {
        AbstractBundleState bundleState = (AbstractBundleState)((Object)unit.getAttachment(AbstractBundleState.class));
        VirtualFile[] roots = this.getClassLoaderPolicyRoots(bundleState, unit);
        OSGiClassLoaderPolicy policy = new OSGiClassLoaderPolicy(bundleState, roots);
        unit.addAttachment(ClassLoaderPolicy.class, (Object)policy);
        return policy;
    }

    private VirtualFile[] getClassLoaderPolicyRoots(AbstractBundleState bundleState, VFSDeploymentUnit vfsUnit) {
        List classPaths = vfsUnit.getClassPath();
        VirtualFile[] policyRoots = new VirtualFile[classPaths.size()];
        classPaths.toArray(policyRoots);
        return policyRoots;
    }
}

