/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.classloading;

import java.util.Map;
import org.jboss.classloading.spi.version.VersionRange;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.classloading.OSGiBundleRequirement;
import org.jboss.osgi.framework.metadata.ParameterizedAttribute;
import org.jboss.osgi.framework.metadata.internal.AbstractVersionRange;

public class OSGiRequiredBundleRequirement
extends OSGiBundleRequirement {
    private static final long serialVersionUID = 1L;
    private String visibility;
    private String resolution;

    public static OSGiRequiredBundleRequirement create(AbstractBundleState bundleState, ParameterizedAttribute metadata) {
        if (metadata == null) {
            throw new IllegalArgumentException("Null metadata");
        }
        String name = metadata.getAttribute();
        AbstractVersionRange versionRange = null;
        String versionStr = (String)metadata.getAttributeValue("bundle-version", String.class);
        if (versionStr != null) {
            versionRange = AbstractVersionRange.valueOf((String)versionStr);
        }
        String visibility = (String)metadata.getDirectiveValue("visibility", String.class);
        String resolution = (String)metadata.getDirectiveValue("resolution", String.class);
        return new OSGiRequiredBundleRequirement(bundleState, name, (VersionRange)versionRange, visibility, resolution, metadata);
    }

    private OSGiRequiredBundleRequirement(AbstractBundleState bundleState, String name, VersionRange versionRange, String visdir, String resdir, ParameterizedAttribute metadata) {
        super(bundleState, name, versionRange, metadata);
        this.visibility = visdir;
        if (this.visibility == null) {
            this.visibility = "private";
        }
        this.resolution = resdir;
        if (this.resolution == null) {
            this.resolution = "mandatory";
        }
        if ("reexport".equals(this.visibility)) {
            this.setReExport(true);
        }
        if ("optional".equals(this.resolution)) {
            this.setOptional(true);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof OSGiRequiredBundleRequirement)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    protected void toString(StringBuffer buffer) {
        super.toString(buffer);
        Map directives = this.getMetadata().getDirectives();
        if (!directives.containsKey("visibility")) {
            buffer.append(",visibility:=" + this.visibility);
        }
        if (!directives.containsKey("resolution")) {
            buffer.append(",resolution:=" + this.resolution);
        }
    }
}

