/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.deployers;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.osgi.framework.metadata.OSGiMetaData;
import org.jboss.osgi.framework.metadata.internal.OSGiManifestMetaData;

public abstract class AbstractOSGiMetaDataDeployer<T>
extends AbstractDeployer {
    private Class<T> attachmentType;

    protected AbstractOSGiMetaDataDeployer(Class<T> attachmentType) {
        if (attachmentType == null) {
            throw new IllegalArgumentException("Null attachment type");
        }
        this.attachmentType = attachmentType;
        this.setStage(DeploymentStages.POST_PARSE);
        this.setOutput(OSGiMetaData.class);
        this.setInput(attachmentType);
        this.setTopLevelOnly(true);
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        Object attachment;
        OSGiMetaData metadata;
        if (unit.isAttachmentPresent(OSGiMetaData.class)) {
            return;
        }
        if (unit.isAttachmentPresent(OSGiManifestMetaData.class)) {
            OSGiMetaData metadata2 = (OSGiMetaData)unit.getAttachment(OSGiManifestMetaData.class);
            unit.addAttachment(OSGiMetaData.class, (Object)metadata2);
            return;
        }
        if (unit.isAttachmentPresent(this.attachmentType) && (metadata = this.createOSGiMetaData(unit, attachment = unit.getAttachment(this.attachmentType))) != null) {
            unit.addAttachment(OSGiMetaData.class, (Object)metadata);
        }
    }

    protected abstract OSGiMetaData createOSGiMetaData(DeploymentUnit var1, T var2);
}

