/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.deployers;

import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.bundle.OSGiBundleState;
import org.jboss.osgi.framework.bundle.OSGiFragmentState;
import org.jboss.osgi.framework.classloading.OSGiClassLoaderPolicy;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;

public class OSGiFragmentAttachmentDeployer
extends AbstractSimpleRealDeployer<ClassLoadingMetaData> {
    static final int RELATIVE_ORDER = 100;

    public OSGiFragmentAttachmentDeployer() {
        super(ClassLoadingMetaData.class);
        this.setStage(DeploymentStages.CLASSLOADER);
        this.setRelativeOrder(100);
        this.setTopLevelOnly(true);
    }

    public void deploy(DeploymentUnit unit, ClassLoadingMetaData classLoadingMetaData) throws DeploymentException {
        AbstractBundleState absBundleState = (AbstractBundleState)((Object)unit.getAttachment(AbstractBundleState.class));
        if (absBundleState == null) {
            return;
        }
        OSGiBundleManager bundleManager = absBundleState.getBundleManager();
        if (!absBundleState.isFragment()) {
            OSGiBundleState hostState = (OSGiBundleState)absBundleState;
            for (AbstractBundleState auxBundle : bundleManager.getBundles(2)) {
                OSGiFragmentState auxState;
                if (!auxBundle.isFragment() || !hostState.isFragmentAttachable(auxState = (OSGiFragmentState)auxBundle)) continue;
                hostState.attachFragment(auxState);
            }
        }
        if (absBundleState.isFragment()) {
            OSGiFragmentState fragState = (OSGiFragmentState)absBundleState;
            OSGiBundleState hostState = fragState.getFragmentHost();
            DeploymentUnit hostUnit = hostState.getDeploymentUnit();
            OSGiClassLoaderPolicy hostPolicy = (OSGiClassLoaderPolicy)((Object)hostUnit.getAttachment(ClassLoaderPolicy.class));
            hostPolicy.attachFragment((org.jboss.vfs.VirtualFile)AbstractVFS.adapt((VirtualFile)fragState.getRoot()));
        }
    }
}

