/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.deployers;

import java.util.List;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.logging.Logger;
import org.jboss.osgi.framework.deployers.AbstractOSGiMetaDataDeployer;
import org.jboss.osgi.framework.metadata.OSGiMetaData;
import org.jboss.osgi.framework.metadata.OSGiMetaDataBuilder;

public class OSGiKernelDeploymentDeployer
extends AbstractOSGiMetaDataDeployer<KernelDeployment> {
    private static final Logger log = Logger.getLogger(OSGiKernelDeploymentDeployer.class);

    public OSGiKernelDeploymentDeployer() {
        super(KernelDeployment.class);
    }

    @Override
    protected OSGiMetaData createOSGiMetaData(DeploymentUnit unit, KernelDeployment attachment) {
        OSGiMetaData meatadata = null;
        List beansMetaData = attachment.getBeans();
        if (beansMetaData != null) {
            String symbolicName = unit.getName();
            OSGiMetaDataBuilder builder = OSGiMetaDataBuilder.createBuilder((String)symbolicName);
            for (BeanMetaData bmd : beansMetaData) {
                String className = bmd.getBean();
                if (className != null && !className.startsWith("java.")) {
                    String packageName = className.substring(0, className.lastIndexOf("."));
                    builder.addExportPackages(new String[]{packageName});
                    continue;
                }
                log.debug((Object)("Ignore export package for: " + bmd));
            }
            meatadata = builder.getOSGiMetaData();
        }
        return meatadata;
    }
}

