/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.deployers;

import java.util.jar.Manifest;
import org.jboss.deployers.vfs.spi.deployer.ManifestDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.osgi.framework.metadata.internal.OSGiManifestMetaData;
import org.jboss.osgi.spi.util.BundleInfo;
import org.jboss.vfs.VirtualFile;

public class OSGiManifestParsingDeployer
extends ManifestDeployer<OSGiManifestMetaData> {
    public OSGiManifestParsingDeployer() {
        super(OSGiManifestMetaData.class);
        this.setTopLevelOnly(true);
    }

    protected OSGiManifestMetaData createMetaData(Manifest manifest) throws Exception {
        int manifestVersion = BundleInfo.getBundleManifestVersion((Manifest)manifest);
        if (manifestVersion < 0 || manifestVersion > 2) {
            return null;
        }
        OSGiManifestMetaData osgiMetaData = new OSGiManifestMetaData(manifest);
        return osgiMetaData;
    }

    protected void init(VFSDeploymentUnit unit, OSGiManifestMetaData osgiMetaData, VirtualFile file) throws Exception {
        super.init(unit, (Object)osgiMetaData, file);
        String symbolicName = osgiMetaData.getBundleSymbolicName();
        if (symbolicName != null) {
            this.log.debug((Object)("Bundle-SymbolicName: " + symbolicName));
            unit.addAttachment("org.jboss.osgi.bundle.symbolic.name", (Object)symbolicName);
        }
    }
}

