/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.launch;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jboss.dependency.plugins.AbstractControllerContext;
import org.jboss.dependency.plugins.AbstractControllerContextActions;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerContextActions;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.plugins.deployment.xml.BasicXMLDeployer;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.logging.Logger;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.launch.OSGiFramework;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;

public class OSGiFrameworkFactory
implements FrameworkFactory {
    final Logger log = Logger.getLogger(OSGiFrameworkFactory.class);
    public static final String BOOTSTRAP_URLS = "org.jboss.osgi.framework.bootstrap.urls";
    public static final String BOOTSTRAP_PATHS = "org.jboss.osgi.framework.bootstrap.paths";

    public static void main(String[] args) throws Exception {
        OSGiFrameworkFactory factory = new OSGiFrameworkFactory();
        Framework framework = factory.newFramework(null);
        framework.start();
    }

    public Framework newFramework(Map configuration) {
        BasicBootstrap bootstrap = new BasicBootstrap();
        bootstrap.run();
        Kernel kernel = bootstrap.getKernel();
        KernelController controller = this.preinstallKernelBeans(kernel);
        BasicXMLDeployer deployer = new BasicXMLDeployer(kernel, ControllerMode.AUTOMATIC);
        ArrayList<URL> urls = null;
        String bootstrapURLs = this.getProperty(BOOTSTRAP_URLS);
        if (bootstrapURLs != null) {
            this.log.debug((Object)("System defined bootstrap url(s): " + bootstrapURLs));
            urls = new ArrayList<URL>();
            for (String url : bootstrapURLs.split(" ")) {
                try {
                    urls.add(new URL(url));
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException("Invalid system property org.jboss.osgi.framework.bootstrap.urls", e);
                }
            }
        }
        String bootstrapPaths = this.getProperty(BOOTSTRAP_PATHS);
        if (urls == null && bootstrapPaths != null) {
            this.log.debug((Object)("System defined bootstrap path(s): " + bootstrapPaths));
            urls = new ArrayList();
            for (String path : bootstrapPaths.split(" ")) {
                URL url = this.getResourceURL(path);
                if (url == null) {
                    throw new IllegalStateException("Cannot find bootstrap: " + path);
                }
                urls.add(url);
            }
        }
        if (urls == null) {
            ArrayList<String> bootstraps = new ArrayList<String>();
            bootstraps.add("META-INF/jboss-osgi-bootstrap-system.xml");
            bootstraps.add("META-INF/jboss-osgi-bootstrap-container.xml");
            bootstraps.add("META-INF/jboss-osgi-bootstrap.xml");
            bootstraps.add("jboss-osgi-bootstrap.xml");
            urls = new ArrayList();
            for (String path : bootstraps) {
                URL url = this.getResourceURL(path);
                if (url == null) continue;
                urls.add(url);
            }
            if (urls.size() == 0) {
                throw new IllegalStateException("Cannot find any bootstrap: " + Arrays.asList(bootstraps));
            }
        }
        try {
            for (URL url : urls) {
                this.log.debug((Object)("Deploy framework bootstrap: " + url));
                deployer.deploy(url);
            }
            deployer.validate();
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Cannot deploy bootstrap beans", ex);
        }
        ControllerContext managerContext = controller.getInstalledContext((Object)"OSGiBundleManager");
        if (managerContext == null) {
            throw new IllegalStateException("Cannot obtain installed bean: OSGiBundleManager");
        }
        OSGiBundleManager manager = (OSGiBundleManager)managerContext.getTarget();
        if (configuration != null) {
            manager.setProperties(configuration);
        }
        return new OSGiFramework(manager);
    }

    private URL getResourceURL(String resourceName) {
        URL url = null;
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        if (contextLoader != null) {
            url = contextLoader.getResource(resourceName);
        }
        if (url == null) {
            url = this.getClass().getResource(resourceName);
        }
        return url;
    }

    private KernelController preinstallKernelBeans(Kernel kernel) {
        KernelController controller = kernel.getController();
        AbstractControllerContextActions actions = new AbstractControllerContextActions(new HashMap());
        try {
            controller.install((ControllerContext)new AbstractControllerContext((Object)"jboss.kernel:service=KernelController", (ControllerContextActions)actions, null, (Object)controller));
            controller.install((ControllerContext)new AbstractControllerContext((Object)"jboss.kernel:service=Kernel", (ControllerContextActions)actions, null, (Object)kernel));
        }
        catch (Throwable th) {
            throw new IllegalStateException("Cannot preinstall kernel bean", th);
        }
        return controller;
    }

    private String getProperty(final String propertyName) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return System.getProperty(propertyName);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(propertyName);
            }
        });
    }
}

