/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.packageadmin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.classloading.plugins.metadata.PackageCapability;
import org.jboss.classloading.spi.dependency.ClassLoading;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.metadata.CapabilitiesMetaData;
import org.jboss.classloading.spi.metadata.Capability;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.IncompleteDeploymentException;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStage;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.bundle.DeployedBundleState;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.bundle.OSGiBundleState;
import org.jboss.osgi.framework.bundle.OSGiFragmentState;
import org.jboss.osgi.framework.bundle.OSGiSystemState;
import org.jboss.osgi.framework.classloading.OSGiModule;
import org.jboss.osgi.framework.packageadmin.CapabilityExportedPackage;
import org.jboss.osgi.framework.packageadmin.SystemExportedPackage;
import org.jboss.osgi.framework.plugins.PackageAdminPlugin;
import org.jboss.osgi.framework.plugins.ResolverPlugin;
import org.jboss.osgi.framework.plugins.SystemPackagesPlugin;
import org.jboss.osgi.framework.plugins.internal.AbstractServicePlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;

public class PackageAdminImpl
extends AbstractServicePlugin
implements PackageAdminPlugin {
    private static final Logger log = Logger.getLogger(PackageAdminImpl.class);

    public PackageAdminImpl(OSGiBundleManager bundleManager) {
        super(bundleManager);
    }

    @Override
    public void startService() {
        BundleContext sysContext = this.getSystemContext();
        sysContext.registerService(PackageAdmin.class.getName(), (Object)this, null);
    }

    @Override
    public void stopService() {
    }

    public Bundle getBundle(Class clazz) {
        DeploymentUnit unit;
        AbstractBundleState bundleState;
        if (clazz == null) {
            throw new IllegalArgumentException("Null class");
        }
        ClassLoader classLoader = clazz.getClassLoader();
        Module module = ClassLoading.getModuleForClassLoader((ClassLoader)classLoader);
        if (module instanceof OSGiModule && (bundleState = (AbstractBundleState)((Object)(unit = ((OSGiModule)module).getDeploymentUnit()).getAttachment(AbstractBundleState.class))) != null) {
            if (bundleState.isFragment()) {
                bundleState = ((OSGiFragmentState)bundleState).getFragmentHost();
            }
            return bundleState.getBundleInternal();
        }
        return null;
    }

    public int getBundleType(Bundle bundle) {
        AbstractBundleState bundleState = AbstractBundleState.assertBundleState(bundle);
        return bundleState.isFragment() ? 1 : 0;
    }

    public Bundle[] getBundles(String symbolicName, String versionRange) {
        if (symbolicName == null) {
            throw new IllegalArgumentException("Null symbolic name");
        }
        ArrayList<Bundle> result = new ArrayList<Bundle>();
        for (AbstractBundleState bundleState : this.getBundleManager().getBundles()) {
            if (!symbolicName.equals(bundleState.getSymbolicName())) continue;
            result.add(bundleState.getBundleInternal());
        }
        return result.toArray(new Bundle[result.size()]);
    }

    public ExportedPackage getExportedPackage(String name) {
        return null;
    }

    public ExportedPackage[] getExportedPackages(Bundle bundle) {
        List<Object> exported = new ArrayList();
        if (bundle != null) {
            exported = this.getExportedPackagesInternal(bundle);
        } else {
            for (AbstractBundleState aux : this.getBundleManager().getBundles()) {
                exported.addAll(this.getExportedPackagesInternal(aux));
            }
        }
        if (exported.size() == 0) {
            return null;
        }
        ExportedPackage[] result = new ExportedPackage[exported.size()];
        exported.toArray(result);
        return result;
    }

    private List<ExportedPackage> getExportedPackagesInternal(Bundle bundle) {
        ArrayList<ExportedPackage> exported = new ArrayList<ExportedPackage>();
        AbstractBundleState absBundleState = AbstractBundleState.assertBundleState(bundle);
        if (absBundleState instanceof OSGiSystemState) {
            OSGiSystemState bundleState = (OSGiSystemState)absBundleState;
            SystemPackagesPlugin plugin = bundleState.getBundleManager().getPlugin(SystemPackagesPlugin.class);
            for (String packageName : plugin.getSystemPackages(false)) {
                exported.add(new SystemExportedPackage(bundleState, packageName));
            }
        } else {
            DeployedBundleState bundleState = (DeployedBundleState)absBundleState;
            ClassLoadingMetaData metaData = (ClassLoadingMetaData)bundleState.getDeploymentUnit().getAttachment(ClassLoadingMetaData.class);
            if (metaData == null) {
                throw new IllegalStateException("Cannot obtain ClassLoadingMetaData for: " + bundle);
            }
            CapabilitiesMetaData capabilities = metaData.getCapabilities();
            for (Capability capability : capabilities.getCapabilities()) {
                if (!(capability instanceof PackageCapability)) continue;
                exported.add(new CapabilityExportedPackage((AbstractBundleState)bundleState, (PackageCapability)capability));
            }
        }
        return exported;
    }

    public ExportedPackage[] getExportedPackages(String name) {
        ArrayList<ExportedPackage> exported = new ArrayList<ExportedPackage>();
        for (AbstractBundleState auxBundle : this.getBundleManager().getBundles()) {
            ExportedPackage[] exportedPackages = this.getExportedPackages(auxBundle);
            if (exportedPackages == null) continue;
            for (ExportedPackage auxPackage : exportedPackages) {
                if (!auxPackage.getName().equals(name)) continue;
                exported.add(auxPackage);
            }
        }
        if (exported.size() == 0) {
            return null;
        }
        ExportedPackage[] result = new ExportedPackage[exported.size()];
        exported.toArray(result);
        return result;
    }

    public Bundle[] getFragments(Bundle bundle) {
        AbstractBundleState absBundleState = AbstractBundleState.assertBundleState(bundle);
        if (!(absBundleState instanceof OSGiBundleState)) {
            return null;
        }
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        OSGiBundleState bundleState = (OSGiBundleState)absBundleState;
        List<OSGiFragmentState> fragments = bundleState.getAttachedFragments();
        for (OSGiFragmentState aux : fragments) {
            bundles.add(aux.getBundleInternal());
        }
        if (bundles.isEmpty()) {
            return null;
        }
        return bundles.toArray(new Bundle[bundles.size()]);
    }

    public Bundle[] getHosts(Bundle bundle) {
        AbstractBundleState absBundleState = AbstractBundleState.assertBundleState(bundle);
        if (!(absBundleState instanceof OSGiFragmentState)) {
            return null;
        }
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        OSGiFragmentState bundleState = (OSGiFragmentState)absBundleState;
        OSGiBundleState fragmentHost = bundleState.getFragmentHost();
        if (fragmentHost != null) {
            bundles.add(fragmentHost.getBundle());
        }
        if (bundles.isEmpty()) {
            return null;
        }
        return bundles.toArray(new Bundle[bundles.size()]);
    }

    public RequiredBundle[] getRequiredBundles(String symbolicName) {
        return null;
    }

    public void refreshPackages(Bundle[] bundles) {
    }

    public boolean resolveBundles(Bundle[] bundleArr) {
        boolean allResolved;
        ArrayList<Bundle> unresolvedBundles = new ArrayList<Bundle>();
        if (bundleArr == null) {
            for (AbstractBundleState bundle : this.getBundleManager().getBundles(2)) {
                DeployedBundleState bundleState = DeployedBundleState.assertBundleState(bundle);
                unresolvedBundles.add(bundleState);
            }
        } else {
            for (Bundle bundle : bundleArr) {
                if (bundle.getState() != 2) continue;
                unresolvedBundles.add(DeployedBundleState.assertBundleState(bundle));
            }
        }
        if (unresolvedBundles.isEmpty()) {
            return true;
        }
        Iterator itBundles = unresolvedBundles.iterator();
        while (itBundles.hasNext()) {
            DeployedBundleState bundleState = DeployedBundleState.assertBundleState((Bundle)itBundles.next());
            try {
                this.verifyExecutionEnvironment(bundleState, true);
            }
            catch (BundleException ex) {
                itBundles.remove();
            }
        }
        ArrayList<OSGiBundleState> resolvableBundles = new ArrayList<OSGiBundleState>();
        ResolverPlugin bundleResolver = this.getBundleManager().getOptionalPlugin(ResolverPlugin.class);
        if (bundleResolver != null) {
            for (Bundle aux : bundleResolver.resolve(unresolvedBundles)) {
                if (AbstractBundleState.assertBundleState(aux).isFragment()) continue;
                resolvableBundles.add(OSGiBundleState.assertBundleState(aux));
            }
        } else {
            for (Bundle aux : unresolvedBundles) {
                if (AbstractBundleState.assertBundleState(aux).isFragment()) continue;
                resolvableBundles.add(OSGiBundleState.assertBundleState(aux));
            }
        }
        boolean bl = allResolved = resolvableBundles.size() > 0;
        if (!this.advanceBundlesToClassloader(resolvableBundles)) {
            this.resetBundleDeploymentStates(resolvableBundles);
            allResolved = false;
        }
        return allResolved;
    }

    private boolean advanceBundlesToClassloader(List<OSGiBundleState> resolvableBundles) {
        DeploymentUnit unit;
        DeployerClient deployerClient = this.getBundleManager().getDeployerClient();
        for (OSGiBundleState bundleState : resolvableBundles) {
            unit = bundleState.getDeploymentUnit();
            unit.addAttachment(StateTuple.class, (Object)new StateTuple(unit));
        }
        for (OSGiBundleState bundleState : resolvableBundles) {
            try {
                unit = bundleState.getDeploymentUnit();
                deployerClient.change(unit.getName(), DeploymentStages.CLASSLOADER);
                for (OSGiFragmentState fragment : bundleState.getAttachedFragments()) {
                    String fragUnitName = fragment.getDeploymentUnit().getName();
                    deployerClient.change(fragUnitName, DeploymentStages.CLASSLOADER);
                }
            }
            catch (DeploymentException ex) {
                log.error((Object)("Error resolving bundle: " + (Object)((Object)bundleState)), (Throwable)ex);
            }
        }
        try {
            deployerClient.checkComplete();
            return true;
        }
        catch (DeploymentException ex) {
            log.error((Object)("Error resolving bundles: " + resolvableBundles), (Throwable)ex);
            if (ex instanceof IncompleteDeploymentException) {
                // empty if block
            }
            return false;
        }
    }

    private void resetBundleDeploymentStates(List<OSGiBundleState> resolvableBundles) {
        for (OSGiBundleState bundleState : resolvableBundles) {
            DeploymentUnit unit = bundleState.getDeploymentUnit();
            StateTuple stateTuple = (StateTuple)unit.removeAttachment(StateTuple.class);
            if (stateTuple == null) continue;
            stateTuple.reset(unit);
        }
    }

    private boolean verifyExecutionEnvironment(AbstractBundleState bundleState, boolean errorOnFail) throws BundleException {
        List reqExecEnvs = bundleState.getOSGiMetaData().getRequiredExecutionEnvironment();
        if (reqExecEnvs == null) {
            return true;
        }
        boolean foundExecEnv = false;
        String fwExecEnvs = this.getBundleManager().getProperty("org.osgi.framework.executionenvironment");
        for (String aux : reqExecEnvs) {
            if (!fwExecEnvs.contains(aux)) continue;
            foundExecEnv = true;
            break;
        }
        if (!foundExecEnv) {
            String msg = "Cannot find required execution environment " + reqExecEnvs + ", we have: " + fwExecEnvs;
            if (errorOnFail) {
                throw new BundleException(msg);
            }
            log.error((Object)msg);
        }
        return foundExecEnv;
    }

    static class StateTuple {
        ControllerState requiredState;
        DeploymentStage requiredStage;

        StateTuple(DeploymentUnit unit) {
            ControllerContext context = (ControllerContext)unit.getAttachment(ControllerContext.class);
            this.requiredState = context.getRequiredState();
            this.requiredStage = unit.getRequiredStage();
        }

        void reset(DeploymentUnit unit) {
            ControllerContext context = (ControllerContext)unit.getAttachment(ControllerContext.class);
            context.setRequiredState(this.requiredState);
            unit.setRequiredStage(this.requiredStage);
        }
    }
}

