/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.plugins.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.classloading.OSGiCoreClassFilter;
import org.jboss.osgi.framework.plugins.SystemPackagesPlugin;
import org.jboss.osgi.framework.plugins.internal.AbstractPlugin;

public class SystemPackagesPluginImpl
extends AbstractPlugin
implements SystemPackagesPlugin {
    final Logger log = Logger.getLogger(SystemPackagesPluginImpl.class);
    private List<String> allPackages = new ArrayList<String>();
    private List<String> allPackageNames = new ArrayList<String>();

    public SystemPackagesPluginImpl(OSGiBundleManager bundleManager) {
        super(bundleManager);
        String systemPackages = this.getBundleManager().getProperty("org.osgi.framework.system.packages");
        this.initSystemPackages(systemPackages);
    }

    public void initSystemPackages(String systemPackages) {
        if (systemPackages != null) {
            this.allPackages.addAll(this.packagesAsList(systemPackages));
        } else {
            this.allPackages.add("javax.imageio");
            this.allPackages.add("javax.imageio.stream");
            this.allPackages.add("javax.management");
            this.allPackages.add("javax.management.loading");
            this.allPackages.add("javax.management.modelmbean");
            this.allPackages.add("javax.management.monitor");
            this.allPackages.add("javax.management.openmbean");
            this.allPackages.add("javax.management.relation");
            this.allPackages.add("javax.management.remote");
            this.allPackages.add("javax.management.remote.rmi");
            this.allPackages.add("javax.management.timer");
            this.allPackages.add("javax.naming");
            this.allPackages.add("javax.naming.event");
            this.allPackages.add("javax.naming.spi");
            this.allPackages.add("javax.net");
            this.allPackages.add("javax.net.ssl");
            this.allPackages.add("javax.security.cert");
            this.allPackages.add("javax.xml.datatype");
            this.allPackages.add("javax.xml.namespace");
            this.allPackages.add("javax.xml.parsers");
            this.allPackages.add("javax.xml.validation");
            this.allPackages.add("javax.xml.transform");
            this.allPackages.add("javax.xml.transform.dom");
            this.allPackages.add("javax.xml.transform.sax");
            this.allPackages.add("javax.xml.transform.stream");
            this.allPackages.add("org.jboss.osgi.deployment.deployer");
            this.allPackages.add("org.jboss.osgi.deployment.interceptor");
            String[] corePackages = OSGiCoreClassFilter.getCorePackages();
            this.allPackages.addAll(Arrays.asList(corePackages));
            this.allPackages.add("org.w3c.dom");
            this.allPackages.add("org.w3c.dom.bootstrap");
            this.allPackages.add("org.w3c.dom.ls");
            this.allPackages.add("org.w3c.dom.events");
            this.allPackages.add("org.w3c.dom.ranges");
            this.allPackages.add("org.w3c.dom.views");
            this.allPackages.add("org.w3c.dom.traversal");
            this.allPackages.add("org.xml.sax");
            this.allPackages.add("org.xml.sax.ext");
            this.allPackages.add("org.xml.sax.helpers");
            String asString = this.packagesAsString(this.allPackages);
            this.getBundleManager().setProperty("org.osgi.framework.system.packages", asString);
        }
        String extraPackages = this.getBundleManager().getProperty("org.osgi.framework.system.packages.extra");
        if (extraPackages != null) {
            this.allPackages.addAll(this.packagesAsList(extraPackages));
        }
        Collections.sort(this.allPackages);
        for (String name : this.allPackages) {
            this.log.debug((Object)("   " + name));
            int semiIndex = name.indexOf(59);
            if (semiIndex > 0) {
                name = name.substring(0, semiIndex);
            }
            this.allPackageNames.add(name);
        }
    }

    @Override
    public List<String> getSystemPackages(boolean version) {
        return Collections.unmodifiableList(version ? this.allPackages : this.allPackageNames);
    }

    @Override
    public boolean isSystemPackage(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null package name");
        }
        int semiIndex = name.indexOf(59);
        if (semiIndex > 0) {
            name = name.substring(0, semiIndex);
        }
        return this.allPackageNames.contains(name);
    }

    private String packagesAsString(List<String> sysPackages) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < sysPackages.size(); ++i) {
            if (i > 0) {
                result.append(",");
            }
            result.append(sysPackages.get(i));
        }
        return result.toString();
    }

    private List<String> packagesAsList(String sysPackages) {
        ArrayList<String> result = new ArrayList<String>();
        for (String name : sysPackages.split(",")) {
            result.add(name.trim());
        }
        return result;
    }
}

