/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.resolver.felix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.framework.capabilityset.Attribute;
import org.apache.felix.framework.capabilityset.Capability;
import org.apache.felix.framework.capabilityset.Directive;
import org.apache.felix.framework.capabilityset.Requirement;
import org.apache.felix.framework.resolver.FragmentRequirement;
import org.apache.felix.framework.resolver.Module;
import org.apache.felix.framework.util.VersionRange;
import org.apache.felix.framework.util.manifestparser.CapabilityImpl;
import org.apache.felix.framework.util.manifestparser.RequirementImpl;
import org.jboss.logging.Logger;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.classloading.OSGiBundleCapability;
import org.jboss.osgi.framework.classloading.OSGiCapability;
import org.jboss.osgi.framework.classloading.OSGiFragmentHostRequirement;
import org.jboss.osgi.framework.classloading.OSGiPackageCapability;
import org.jboss.osgi.framework.classloading.OSGiPackageRequirement;
import org.jboss.osgi.framework.classloading.OSGiRequiredBundleRequirement;
import org.jboss.osgi.framework.classloading.OSGiRequirement;
import org.jboss.osgi.framework.metadata.PackageAttribute;
import org.jboss.osgi.framework.metadata.Parameter;
import org.jboss.osgi.framework.metadata.ParameterizedAttribute;
import org.jboss.osgi.framework.resolver.AbstractModule;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

abstract class AbstractBundleModule
extends AbstractModule {
    final Logger log = Logger.getLogger(AbstractBundleModule.class);
    private Map<Capability, OSGiCapability> capMap;
    private Map<OSGiRequirement, Requirement> reqMap;
    private Map<OSGiRequirement, Requirement> dynReqMap;

    public AbstractBundleModule(AbstractBundleState bundleState) {
        super((Bundle)bundleState);
    }

    abstract List<OSGiCapability> getOSGiCapabilities();

    abstract List<OSGiRequirement> getOSGiRequirements();

    public List<Capability> createCapabilities() {
        this.capMap = new LinkedHashMap<Capability, OSGiCapability>();
        for (OSGiCapability mccap : this.getOSGiCapabilities()) {
            OSGiCapability osgicap;
            if (mccap instanceof OSGiBundleCapability) {
                ArrayList<Attribute> attrs;
                osgicap = (OSGiBundleCapability)mccap;
                if (!mccap.getBundleState().isFragment()) {
                    attrs = new ArrayList<Attribute>(2);
                    attrs.add(new Attribute("bundle-symbolic-name", (Object)osgicap.getName(), false));
                    attrs.add(new Attribute("bundle-version", osgicap.getVersion(), false));
                    this.capMap.put((Capability)new CapabilityImpl((Module)this, "host", new ArrayList(0), attrs), osgicap);
                }
                attrs = new ArrayList(2);
                attrs.add(new Attribute("bundle-symbolic-name", (Object)osgicap.getName(), false));
                attrs.add(new Attribute("bundle-version", osgicap.getVersion(), false));
                this.capMap.put((Capability)new CapabilityImpl((Module)this, "module", new ArrayList(0), attrs), osgicap);
                continue;
            }
            if (mccap instanceof OSGiPackageCapability) {
                osgicap = (OSGiPackageCapability)mccap;
                Capability cap = this.packageCapability((OSGiPackageCapability)osgicap);
                this.capMap.put(cap, osgicap);
                continue;
            }
            throw new IllegalArgumentException("Unsupported capability: " + mccap);
        }
        ArrayList<Capability> result = new ArrayList<Capability>(this.capMap.keySet());
        for (Module aux : this.getFragments()) {
            AbstractBundleModule fragModule = (AbstractBundleModule)aux;
            for (Capability fragCap : fragModule.getCapabilities()) {
                CapabilityImpl cap = new CapabilityImpl((Module)this, fragCap.getNamespace(), fragCap.getDirectives(), fragCap.getAttributes());
                result.add((Capability)cap);
            }
        }
        return Collections.unmodifiableList(result);
    }

    public List<Requirement> createRequirements() {
        this.reqMap = new LinkedHashMap<OSGiRequirement, Requirement>();
        for (OSGiRequirement mcreq : this.getOSGiRequirements()) {
            Requirement req;
            OSGiRequirement osgireq;
            if (mcreq instanceof OSGiRequiredBundleRequirement) {
                osgireq = (OSGiRequiredBundleRequirement)mcreq;
                req = this.requireBundleRequiment((OSGiRequiredBundleRequirement)osgireq);
                this.reqMap.put(osgireq, req);
                continue;
            }
            if (mcreq instanceof OSGiFragmentHostRequirement) {
                osgireq = (OSGiFragmentHostRequirement)mcreq;
                req = this.fragmentHostRequirement((OSGiFragmentHostRequirement)osgireq);
                this.reqMap.put(osgireq, req);
                continue;
            }
            if (mcreq instanceof OSGiPackageRequirement) {
                osgireq = (OSGiPackageRequirement)mcreq;
                if (osgireq.isDynamic()) continue;
                req = this.packageRequirement((OSGiPackageRequirement)osgireq);
                this.reqMap.put(osgireq, req);
                continue;
            }
            throw new IllegalArgumentException("Unsupported requirement: " + mcreq);
        }
        ArrayList<Requirement> result = new ArrayList<Requirement>(this.reqMap.values());
        for (Module auxModule : this.getFragments()) {
            AbstractBundleModule fragModule = (AbstractBundleModule)auxModule;
            for (Requirement aux : fragModule.getRequirements()) {
                if (!"package".equals(aux.getNamespace()) && !"module".equals(aux.getNamespace())) continue;
                FragmentRequirement req = new FragmentRequirement((Module)this, aux);
                result.add((Requirement)req);
            }
        }
        return Collections.unmodifiableList(result);
    }

    protected List<Requirement> createDynamicRequirements() {
        this.dynReqMap = new LinkedHashMap<OSGiRequirement, Requirement>();
        for (OSGiRequirement mcreq : this.getOSGiRequirements()) {
            OSGiPackageRequirement osgireq;
            if (!(mcreq instanceof OSGiPackageRequirement) || !(osgireq = (OSGiPackageRequirement)mcreq).isDynamic()) continue;
            Requirement req = this.packageRequirement(osgireq);
            this.dynReqMap.put(osgireq, req);
        }
        ArrayList<Requirement> result = new ArrayList<Requirement>(this.dynReqMap.values());
        return Collections.unmodifiableList(result);
    }

    OSGiCapability getMappedCapability(Capability cap) {
        if (this.capMap == null) {
            throw new IllegalStateException("Capability map not yet created for: " + this.getBundle());
        }
        return this.capMap.get(cap);
    }

    Requirement getMappedRequirement(OSGiRequirement osgireq) {
        if (this.reqMap == null) {
            throw new IllegalStateException("Requirement map not yet created for: " + this.getBundle());
        }
        return this.reqMap.get(osgireq);
    }

    private Capability packageCapability(OSGiPackageCapability osgicap) {
        AbstractBundleState bundleState = osgicap.getBundleState();
        PackageAttribute metadata = osgicap.getMetadata();
        String symbolicName = null;
        Version bundleVersion = null;
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        attrs.add(new Attribute("package", (Object)osgicap.getName(), false));
        for (Map.Entry entry : metadata.getAttributes().entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)((Parameter)entry.getValue()).getValue();
            if ("version".equals(key)) {
                value = Version.parseVersion((String)value);
            } else if ("bundle-symbolic-name".equals(key)) {
                symbolicName = value;
            } else if ("bundle-version".equals(key)) {
                bundleVersion = Version.parseVersion((String)value);
            }
            attrs.add(new Attribute(key, (Object)value, false));
        }
        if (symbolicName == null) {
            symbolicName = bundleState.getSymbolicName();
            attrs.add(new Attribute("bundle-symbolic-name", (Object)symbolicName, false));
        }
        if (bundleVersion == null) {
            bundleVersion = bundleState.getVersion();
            attrs.add(new Attribute("bundle-version", (Object)bundleVersion, false));
        }
        ArrayList<Directive> dirs = new ArrayList<Directive>();
        for (Map.Entry entry : metadata.getDirectives().entrySet()) {
            dirs.add(new Directive((String)entry.getKey(), ((Parameter)entry.getValue()).getValue()));
        }
        CapabilityImpl cap = new CapabilityImpl((Module)this, "package", dirs, attrs);
        return cap;
    }

    private Requirement packageRequirement(OSGiPackageRequirement osgireq) {
        PackageAttribute metadata = osgireq.getMetadata();
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        attrs.add(new Attribute("package", (Object)osgireq.getName(), false));
        for (Map.Entry entry : metadata.getAttributes().entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)((Parameter)entry.getValue()).getValue();
            if ("version".equals(key)) {
                value = VersionRange.parse((String)value);
            } else if ("bundle-version".equals(key)) {
                value = VersionRange.parse((String)value);
            }
            attrs.add(new Attribute(key, (Object)value, false));
        }
        ArrayList<Directive> dirs = new ArrayList<Directive>();
        for (Map.Entry entry : metadata.getDirectives().entrySet()) {
            dirs.add(new Directive((String)entry.getKey(), ((Parameter)entry.getValue()).getValue()));
        }
        RequirementImpl req = new RequirementImpl((Module)this, "package", dirs, attrs);
        return req;
    }

    private Requirement requireBundleRequiment(OSGiRequiredBundleRequirement osgireq) {
        ParameterizedAttribute metadata = osgireq.getMetadata();
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        attrs.add(new Attribute("bundle-symbolic-name", (Object)osgireq.getName(), false));
        for (Map.Entry entry : metadata.getAttributes().entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)((Parameter)entry.getValue()).getValue();
            if ("bundle-version".equals(key)) {
                value = VersionRange.parse((String)value);
            }
            attrs.add(new Attribute(key, (Object)value, false));
        }
        ArrayList<Directive> dirs = new ArrayList<Directive>();
        for (Map.Entry entry : metadata.getDirectives().entrySet()) {
            dirs.add(new Directive((String)entry.getKey(), ((Parameter)entry.getValue()).getValue()));
        }
        RequirementImpl req = new RequirementImpl((Module)this, "module", dirs, attrs);
        return req;
    }

    private Requirement fragmentHostRequirement(OSGiFragmentHostRequirement osgireq) {
        ParameterizedAttribute metadata = osgireq.getMetadata();
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        attrs.add(new Attribute("bundle-symbolic-name", (Object)osgireq.getName(), false));
        for (Map.Entry entry : metadata.getAttributes().entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)((Parameter)entry.getValue()).getValue();
            if ("bundle-version".equals(key)) {
                value = VersionRange.parse((String)value);
            }
            attrs.add(new Attribute(key, (Object)value, false));
        }
        ArrayList<Directive> dirs = new ArrayList<Directive>();
        for (Map.Entry entry : metadata.getDirectives().entrySet()) {
            dirs.add(new Directive((String)entry.getKey(), ((Parameter)entry.getValue()).getValue()));
        }
        RequirementImpl req = new RequirementImpl((Module)this, "host", dirs, attrs);
        return req;
    }
}

