/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.resolver.felix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.metadata.Capability;
import org.jboss.classloading.spi.metadata.Requirement;
import org.jboss.logging.Logger;
import org.jboss.osgi.framework.bundle.DeployedBundleState;
import org.jboss.osgi.framework.classloading.OSGiCapability;
import org.jboss.osgi.framework.classloading.OSGiModule;
import org.jboss.osgi.framework.classloading.OSGiRequirement;
import org.jboss.osgi.framework.resolver.felix.AbstractBundleModule;

class DeployedBundleModule
extends AbstractBundleModule {
    final Logger log = Logger.getLogger(DeployedBundleModule.class);
    private OSGiModule moduleDelegate;
    private List<OSGiCapability> capabilities;
    private List<OSGiRequirement> requirements;

    public DeployedBundleModule(DeployedBundleState bundleState) {
        super(bundleState);
    }

    @Override
    List<OSGiCapability> getOSGiCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new ArrayList<OSGiCapability>();
            List mccaps = this.getModuleDelegate().getCapabilities();
            if (mccaps != null) {
                for (Capability mccap : mccaps) {
                    if (mccap instanceof OSGiCapability) {
                        this.capabilities.add((OSGiCapability)mccap);
                        continue;
                    }
                    throw new IllegalArgumentException("Unsupported capability: " + mccap);
                }
            }
        }
        return Collections.unmodifiableList(this.capabilities);
    }

    @Override
    List<OSGiRequirement> getOSGiRequirements() {
        if (this.requirements == null) {
            this.requirements = new ArrayList<OSGiRequirement>();
            if (this.getModuleDelegate().getRequirements() != null) {
                for (Requirement mcreq : this.getModuleDelegate().getRequirements()) {
                    if (mcreq instanceof OSGiRequirement) {
                        this.requirements.add((OSGiRequirement)mcreq);
                        continue;
                    }
                    throw new IllegalArgumentException("Unsupported requirement: " + mcreq);
                }
            }
        }
        return Collections.unmodifiableList(this.requirements);
    }

    private OSGiModule getModuleDelegate() {
        if (this.moduleDelegate == null) {
            DeployedBundleState bundleState = DeployedBundleState.assertBundleState(this.getBundle());
            this.moduleDelegate = (OSGiModule)((Object)bundleState.getDeploymentUnit().getAttachment(Module.class));
            if (this.moduleDelegate == null) {
                throw new IllegalStateException("No OSGiModule attached to: " + (Object)((Object)bundleState));
            }
        }
        return this.moduleDelegate;
    }
}

