/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.resolver.felix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.bundle.OSGiSystemState;
import org.jboss.osgi.framework.classloading.OSGiCapability;
import org.jboss.osgi.framework.classloading.OSGiPackageCapability;
import org.jboss.osgi.framework.classloading.OSGiRequirement;
import org.jboss.osgi.framework.metadata.PackageAttribute;
import org.jboss.osgi.framework.metadata.internal.AbstractPackageAttribute;
import org.jboss.osgi.framework.metadata.internal.AbstractParameter;
import org.jboss.osgi.framework.plugins.SystemPackagesPlugin;
import org.jboss.osgi.framework.resolver.felix.AbstractBundleModule;
import org.osgi.framework.Version;

class SystemBundleModule
extends AbstractBundleModule {
    final Logger log = Logger.getLogger(SystemBundleModule.class);
    private List<OSGiCapability> capabilities;

    public SystemBundleModule(OSGiSystemState bundleState) {
        super(bundleState);
    }

    @Override
    List<OSGiCapability> getOSGiCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new ArrayList<OSGiCapability>();
            OSGiSystemState bundleState = OSGiSystemState.assertBundleState(this.getBundle());
            OSGiBundleManager bundleManager = bundleState.getBundleManager();
            SystemPackagesPlugin plugin = bundleManager.getPlugin(SystemPackagesPlugin.class);
            Iterator<String> i$ = plugin.getSystemPackages(true).iterator();
            while (i$.hasNext()) {
                String packageSpec;
                String packname = packageSpec = i$.next();
                Version version = null;
                int versionIndex = packname.indexOf(";version=");
                if (versionIndex > 0) {
                    packname = packageSpec.substring(0, versionIndex);
                    version = Version.parseVersion((String)packageSpec.substring(versionIndex + 9));
                }
                HashMap<String, AbstractParameter> attrs = new HashMap<String, AbstractParameter>();
                if (version != null) {
                    attrs.put("version", new AbstractParameter(version.toString()));
                }
                AbstractPackageAttribute metadata = new AbstractPackageAttribute(packname, attrs, null);
                this.capabilities.add(OSGiPackageCapability.create(bundleState, (PackageAttribute)metadata));
            }
        }
        return Collections.unmodifiableList(this.capabilities);
    }

    @Override
    List<OSGiRequirement> getOSGiRequirements() {
        return Collections.emptyList();
    }
}

