/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.service.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.logging.Logger;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.bundle.OSGiBundleState;
import org.jboss.osgi.framework.bundle.OSGiSystemState;
import org.jboss.osgi.framework.plugins.FrameworkEventsPlugin;
import org.jboss.osgi.framework.plugins.StartLevelPlugin;
import org.jboss.osgi.framework.plugins.internal.AbstractServicePlugin;
import org.jboss.osgi.framework.service.internal.StartLevelBeanEntry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.service.startlevel.StartLevel;

public class StartLevelImpl
extends AbstractServicePlugin
implements StartLevelPlugin {
    private static final Logger log = Logger.getLogger(StartLevelImpl.class);
    FrameworkEventsPlugin eventsPlugin;
    Executor executor = Executors.newSingleThreadExecutor();
    private int initialStartLevel = 1;
    private Map<String, Integer> initialBundleStartLevels = Collections.emptyMap();
    private ServiceRegistration registration;
    private int startLevel = 0;

    public StartLevelImpl(OSGiBundleManager bundleManager) {
        super(bundleManager);
        this.eventsPlugin = this.getPlugin(FrameworkEventsPlugin.class);
        String beginning = bundleManager.getProperty("org.osgi.framework.startlevel.beginning");
        if (beginning != null) {
            try {
                this.initialStartLevel = Integer.parseInt(beginning);
            }
            catch (NumberFormatException nfe) {
                log.error((Object)("Could not set beginning start level to: '" + beginning + "'"));
            }
        }
    }

    public void setBundleMetaData(List<? extends StartLevelBeanEntry> bundles) {
        if (bundles == null) {
            return;
        }
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        for (StartLevelBeanEntry startLevelBeanEntry : bundles) {
            Version v = Version.parseVersion((String)startLevelBeanEntry.getVersion());
            String key = Version.emptyVersion.equals((Object)v) ? startLevelBeanEntry.getSymbolicName() : startLevelBeanEntry.getSymbolicName() + ":" + startLevelBeanEntry.getVersion();
            int sl = startLevelBeanEntry.getStartLevel();
            if (sl == -1) continue;
            m.put(key, sl);
        }
        this.initialBundleStartLevels = Collections.unmodifiableMap(m);
    }

    @Override
    public void startService() {
        this.registration = this.getSystemContext().registerService(StartLevel.class.getName(), (Object)this, null);
    }

    @Override
    public void stopService() {
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
    }

    public int getBundleStartLevel(Bundle bundle) {
        AbstractBundleState b = AbstractBundleState.assertBundleState(bundle);
        if (b instanceof OSGiSystemState) {
            return 0;
        }
        if (b instanceof OSGiBundleState) {
            return ((OSGiBundleState)b).getStartLevel();
        }
        return 1;
    }

    public int getInitialBundleStartLevel() {
        return this.initialStartLevel;
    }

    @Override
    public int getInitialBundleStartLevel(String bsn, Version version) {
        String key = bsn + ":" + version;
        Integer initial = this.initialBundleStartLevels.get(key);
        if (initial == null && (initial = this.initialBundleStartLevels.get(bsn)) == null) {
            return -1;
        }
        return initial;
    }

    public synchronized int getStartLevel() {
        return this.startLevel;
    }

    public boolean isBundleActivationPolicyUsed(Bundle bundle) {
        return false;
    }

    public boolean isBundlePersistentlyStarted(Bundle bundle) {
        AbstractBundleState bundleState = AbstractBundleState.assertBundleState(bundle);
        return bundleState.isPersistentlyStarted();
    }

    public void setBundleStartLevel(Bundle bundle, int sl) {
        final OSGiBundleState obs = OSGiBundleState.assertBundleState(bundle);
        obs.setStartLevel(sl);
        if (sl <= this.getStartLevel()) {
            if (bundle.getState() == 32) {
                return;
            }
            log.info((Object)("Start Level Service about to start: " + (Object)((Object)obs)));
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    log.info((Object)("Start Level Service starting: " + (Object)((Object)obs)));
                    try {
                        int opts = 1;
                        if (StartLevelImpl.this.isBundleActivationPolicyUsed(obs)) {
                            opts |= 2;
                        }
                        obs.start(opts);
                    }
                    catch (BundleException e) {
                        StartLevelImpl.this.eventsPlugin.fireFrameworkEvent(obs, 2, e);
                    }
                }
            });
        } else {
            if (bundle.getState() != 32) {
                return;
            }
            log.info((Object)("Start Level Service about to stop: " + (Object)((Object)obs)));
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    log.info((Object)("Start Level Service stopping: " + (Object)((Object)obs)));
                    try {
                        obs.stop(1);
                    }
                    catch (BundleException e) {
                        StartLevelImpl.this.eventsPlugin.fireFrameworkEvent(obs, 2, e);
                    }
                }
            });
        }
    }

    public void setInitialBundleStartLevel(int startlevel) {
        this.initialStartLevel = startlevel;
    }

    public synchronized void setStartLevel(final int sl) {
        if (sl > this.getStartLevel()) {
            log.info((Object)("About to increase start level from " + this.getStartLevel() + " to " + sl));
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    log.info((Object)("Increasing start level from " + StartLevelImpl.this.getStartLevel() + " to " + sl));
                    StartLevelImpl.this.increaseStartLevel(sl);
                    StartLevelImpl.this.eventsPlugin.fireFrameworkEvent(StartLevelImpl.this.getSystemContext().getBundle(), 8, null);
                }
            });
        } else if (sl < this.getStartLevel()) {
            log.info((Object)("About to decrease start level from " + this.getStartLevel() + " to " + sl));
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    log.info((Object)("Decreasing start level from " + StartLevelImpl.this.getStartLevel() + " to " + sl));
                    StartLevelImpl.this.decreaseStartLevel(sl);
                    StartLevelImpl.this.eventsPlugin.fireFrameworkEvent(StartLevelImpl.this.getSystemContext().getBundle(), 8, null);
                }
            });
        }
    }

    @Override
    public synchronized void increaseStartLevel(int sl) {
        Collection<AbstractBundleState> bundles = this.getBundleManager().getBundles();
        while (this.startLevel < sl) {
            ++this.startLevel;
            log.info((Object)("Starting bundles for start level " + this.startLevel));
            for (AbstractBundleState b : bundles) {
                OSGiBundleState obs;
                if (!(b instanceof OSGiBundleState) || (obs = (OSGiBundleState)b).getStartLevel() != this.startLevel || !obs.isPersistentlyStarted()) continue;
                try {
                    int opts = 1;
                    if (this.isBundleActivationPolicyUsed(b)) {
                        opts |= 2;
                    }
                    b.start(opts);
                }
                catch (Throwable e) {
                    this.eventsPlugin.fireFrameworkEvent(b, 2, e);
                }
            }
        }
    }

    @Override
    public synchronized void decreaseStartLevel(int sl) {
        Collection<AbstractBundleState> bundles = this.getBundleManager().getBundles();
        while (this.startLevel > sl) {
            log.info((Object)("Stopping bundles for start level " + this.startLevel));
            for (AbstractBundleState b : bundles) {
                OSGiBundleState obs;
                if (!(b instanceof OSGiBundleState) || (obs = (OSGiBundleState)b).getStartLevel() != this.startLevel) continue;
                try {
                    b.stop(1);
                }
                catch (Throwable e) {
                    this.eventsPlugin.fireFrameworkEvent(b, 2, e);
                }
            }
            --this.startLevel;
        }
    }
}

