/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.testing;

import java.util.ArrayList;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaDataFactory;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.attachments.MutableAttachments;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.main.MainDeployerStructure;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.deployment.AbstractKernelDeployment;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.deployers.AbstractDeployment;
import org.jboss.osgi.framework.launch.OSGiFramework;
import org.jboss.osgi.framework.metadata.OSGiMetaData;
import org.jboss.osgi.testing.OSGiFrameworkTest;
import org.jboss.shrinkwrap.api.Archive;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;

public abstract class AbstractFrameworkTest
extends OSGiFrameworkTest {
    protected OSGiBundleManager getBundleManager() {
        Framework framework;
        try {
            framework = AbstractFrameworkTest.getFramework();
        }
        catch (BundleException ex) {
            throw new IllegalStateException("Cannot get the framework", ex);
        }
        return ((OSGiFramework)framework).getBundleManager();
    }

    protected Kernel getKernel() {
        return this.getBundleManager().getKernel();
    }

    protected Object getBean(Object beanName) {
        return this.getBean(beanName, ControllerState.INSTALLED);
    }

    protected Object getBean(Object name, ControllerState state) {
        KernelControllerContext context = this.getControllerContext(name, state);
        return context.getTarget();
    }

    protected KernelControllerContext getControllerContext(Object name) {
        return this.getControllerContext(name, ControllerState.INSTALLED);
    }

    protected KernelControllerContext getControllerContext(Object name, ControllerState state) {
        KernelController controller = this.getKernel().getController();
        KernelControllerContext context = (KernelControllerContext)controller.getContext(name, state);
        if (context == null) {
            throw new IllegalStateException("Bean not found " + name + " at state " + state);
        }
        return context;
    }

    protected ControllerState change(KernelControllerContext context, ControllerState required) throws Throwable {
        KernelController controller = this.getKernel().getController();
        controller.change((ControllerContext)context, required);
        return context.getState();
    }

    protected void checkComplete() throws Exception {
        this.getDeployerClient().checkComplete();
    }

    protected DeploymentUnit getDeploymentUnit(Deployment deployment) throws Exception {
        DeployerClient deployerClient = this.getDeployerClient();
        MainDeployerStructure deployerStructure = (MainDeployerStructure)deployerClient;
        return deployerStructure.getDeploymentUnit(deployment.getName());
    }

    protected DeployerClient getDeployerClient() {
        return this.getBundleManager().getDeployerClient();
    }

    protected Deployment createDeployment(String name, String[] resources, Class<?> ... packages) throws Exception {
        Archive assembly = this.assembleArchive(name, resources, packages);
        Deployment deployment = AbstractDeployment.createDeployment(this.toVirtualFile(assembly));
        return deployment;
    }

    protected Deployment addBeanMetaData(Deployment deployment, Class<?> beanClass) {
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)beanClass.getSimpleName(), (String)beanClass.getName());
        return this.addBeanMetaData(deployment, builder.getBeanMetaData());
    }

    protected Deployment addBeanMetaData(Deployment deployment, BeanMetaData bmd) {
        MutableAttachments att = (MutableAttachments)deployment.getPredeterminedManagedObjects();
        KernelDeployment kdep = (KernelDeployment)att.getAttachment(KernelDeployment.class);
        if (kdep == null) {
            kdep = new AbstractKernelDeployment();
            ((AbstractKernelDeployment)kdep).setBeanFactories(new ArrayList());
            att.addAttachment(KernelDeployment.class, (Object)kdep);
        }
        kdep.getBeanFactories().add((BeanMetaDataFactory)bmd);
        return deployment;
    }

    protected Deployment addOSGiMetaData(Deployment deployment, OSGiMetaData metadata) {
        MutableAttachments att = (MutableAttachments)deployment.getPredeterminedManagedObjects();
        att.addAttachment(OSGiMetaData.class, (Object)metadata);
        return deployment;
    }

    protected Deployment deploy(Deployment deployment) throws Exception {
        this.getDeployerClient().addDeployment(deployment);
        this.getDeployerClient().process();
        this.getDeployerClient().checkComplete();
        return deployment;
    }

    protected void undeploy(Deployment deployment) throws Exception {
        DeployerClient deployerClient = this.getDeployerClient();
        deployerClient.undeploy(new Deployment[]{deployment});
    }

    protected Deployment addDeployment(Deployment deployment) throws DeploymentException {
        this.getDeployerClient().addDeployment(deployment);
        this.getDeployerClient().process();
        return deployment;
    }

    protected ClassLoaderSystem getClassLoaderSystem() {
        return (ClassLoaderSystem)this.getBean("OSGiClassLoaderSystem");
    }

    protected ClassLoaderDomain getClassLoaderDomain() {
        return (ClassLoaderDomain)this.getBean("OSGiClassLoaderDomain");
    }
}

