/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.jndi.internal;

import java.net.InetAddress;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.jboss.net.sockets.DefaultSocketFactory;
import org.jnp.interfaces.Naming;
import org.jnp.server.Main;
import org.jnp.server.NamingBean;
import org.jnp.server.NamingServer;
import org.osgi.framework.BundleContext;

public class JNPServer {
    private static final Logger log = Logger.getLogger(JNPServer.class);
    private String host;
    private int jndiPort;
    private int rmiPort;
    private Main namingMain;
    private Naming namingServer;
    private boolean shutdownRegistry;
    private Registry rmiRegistry;

    public JNPServer(BundleContext context, String host, int jndiPort, int rmiPort) {
        this.host = host;
        this.jndiPort = jndiPort;
        this.rmiPort = rmiPort;
    }

    public void start() {
        try {
            this.rmiRegistry = LocateRegistry.getRegistry(this.host, this.rmiPort);
            try {
                this.rmiRegistry.list();
                log.debug((Object)("RMI registry running at host=" + this.host + ",port=" + this.rmiPort));
            }
            catch (RemoteException e) {
                log.debug((Object)("No RMI registry running at host=" + this.host + ",port=" + this.rmiPort + ".  Will create one."));
                this.rmiRegistry = LocateRegistry.createRegistry(this.rmiPort, null, (RMIServerSocketFactory)new DefaultSocketFactory(InetAddress.getByName(this.host)));
                this.shutdownRegistry = true;
            }
            this.namingMain = new Main();
            this.namingMain.setNamingInfo(this.getNamingBean());
            this.namingMain.setBindAddress(this.host);
            this.namingMain.setPort(this.jndiPort);
            this.namingMain.setRmiBindAddress(this.host);
            this.namingMain.setRmiPort(this.rmiPort);
            this.namingMain.start();
            log.info((Object)("JNDI started: JNP=" + this.host + ":" + this.jndiPort + ", RMI=" + this.host + ":" + this.rmiPort));
        }
        catch (Exception ex) {
            log.error((Object)"Cannot start Naming server", (Throwable)ex);
        }
    }

    public void stop() {
        if (this.namingMain != null) {
            this.namingMain.stop();
            this.namingMain = null;
            this.namingServer = null;
            log.debug((Object)"Naming server stopped");
        }
        if (this.shutdownRegistry) {
            try {
                log.debug((Object)"Shutdown RMI registry");
                UnicastRemoteObject.unexportObject(this.rmiRegistry, true);
            }
            catch (NoSuchObjectException ex) {
                log.warn((Object)"Cannot shutdown RMI registry", (Throwable)ex);
            }
        }
    }

    private NamingBean getNamingBean() {
        NamingBean namingBean = new NamingBean(){

            public Naming getNamingInstance() {
                if (JNPServer.this.namingServer == null) {
                    try {
                        JNPServer.this.namingServer = (Naming)new NamingServer();
                    }
                    catch (NamingException ex) {
                        throw new IllegalStateException("Cannot create NamingServer", ex);
                    }
                }
                return JNPServer.this.namingServer;
            }
        };
        return namingBean;
    }
}

