/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jboss.osgi.framework.metadata.PackageAttribute;
import org.jboss.osgi.framework.metadata.ParameterizedAttribute;
import org.jboss.osgi.framework.metadata.internal.AbstractPackageAttribute;
import org.jboss.osgi.framework.metadata.internal.AbstractParameter;
import org.jboss.osgi.framework.metadata.internal.AbstractParameterizedAttribute;

public class ManifestParser {
    public static void parsePackages(String header, List<PackageAttribute> list) {
        ManifestParser.parse(header, list, true);
    }

    public static void parseParameters(String header, List<ParameterizedAttribute> list) {
        ManifestParser.parse(header, list, false);
    }

    public static void parsePaths(String header, List<ParameterizedAttribute> list) {
        ManifestParser.parse(header, list, false);
    }

    public static void parse(String header, List list, boolean packages) {
        if (header == null) {
            return;
        }
        if (header.length() == 0) {
            throw new IllegalArgumentException("Empty header");
        }
        List<String> clauses = ManifestParser.parseDelimitedString(header, ",");
        for (String clause : clauses) {
            List<String> pieces = ManifestParser.parseDelimitedString(clause, ";");
            ArrayList<String> paths = new ArrayList<String>();
            for (String piece : pieces) {
                if (piece.indexOf(61) >= 0) break;
                paths.add(ManifestParser.unquote(piece));
            }
            if (paths.isEmpty()) {
                throw new IllegalArgumentException("No paths for " + clause);
            }
            HashMap<String, AbstractParameter> directives = null;
            HashMap<String, AbstractParameter> attributes = null;
            for (int i = paths.size(); i < pieces.size(); ++i) {
                String unquoted;
                String value;
                String name;
                String piece = pieces.get(i);
                int seperator = piece.indexOf(":=");
                if (seperator >= 0) {
                    name = piece.substring(0, seperator);
                    value = piece.substring(seperator + 2);
                    if (directives == null) {
                        directives = new HashMap<String, AbstractParameter>();
                    }
                    if (directives.containsKey(unquoted = ManifestParser.unquote(name))) {
                        throw new IllegalStateException("Dupicate directive: " + unquoted);
                    }
                    directives.put(unquoted, new AbstractParameter(ManifestParser.unquote(value)));
                    continue;
                }
                seperator = piece.indexOf("=");
                if (seperator >= 0) {
                    name = piece.substring(0, seperator);
                    value = piece.substring(seperator + 1);
                    if (attributes == null) {
                        attributes = new HashMap<String, AbstractParameter>();
                    }
                    if (attributes.containsKey(unquoted = ManifestParser.unquote(name))) {
                        throw new IllegalStateException("Dupicate attribute: " + unquoted);
                    }
                    attributes.put(unquoted, new AbstractParameter(ManifestParser.unquote(value)));
                    continue;
                }
                throw new IllegalArgumentException("Path " + piece + " should appear before attributes and directives in " + clause);
            }
            for (String path : paths) {
                AbstractParameterizedAttribute metadata = null;
                metadata = packages ? new AbstractPackageAttribute(path, attributes, directives) : new AbstractParameterizedAttribute(path, attributes, directives);
                list.add(metadata);
            }
        }
    }

    private static String unquote(String string) {
        if (string.length() < 2) {
            return string;
        }
        if (string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    private static List<String> parseDelimitedString(String value, String delim) {
        if (value == null) {
            value = "";
        }
        ArrayList<String> list = new ArrayList<String>();
        int CHAR = 1;
        int DELIMITER = 2;
        int STARTQUOTE = 4;
        int ENDQUOTE = 8;
        StringBuilder sb = new StringBuilder();
        int expecting = CHAR | DELIMITER | STARTQUOTE;
        for (int i = 0; i < value.length(); ++i) {
            boolean isQuote;
            char c = value.charAt(i);
            boolean isDelimiter = delim.indexOf(c) >= 0;
            boolean bl = isQuote = c == '\"';
            if (isDelimiter && (expecting & DELIMITER) > 0) {
                list.add(sb.toString().trim());
                sb.delete(0, sb.length());
                expecting = CHAR | DELIMITER | STARTQUOTE;
                continue;
            }
            if (isQuote && (expecting & STARTQUOTE) > 0) {
                sb.append(c);
                expecting = CHAR | ENDQUOTE;
                continue;
            }
            if (isQuote && (expecting & ENDQUOTE) > 0) {
                sb.append(c);
                expecting = CHAR | STARTQUOTE | DELIMITER;
                continue;
            }
            if ((expecting & CHAR) > 0) {
                sb.append(c);
                continue;
            }
            throw new IllegalArgumentException("Invalid delimited string: '" + value + "' delimiter=" + delim);
        }
        if (sb.length() > 0) {
            list.add(sb.toString().trim());
        }
        return list;
    }
}

