/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.classloading.spi.version.VersionRange;

public class NativeLibrary
implements Serializable {
    private static final long serialVersionUID = -1637806718398794304L;
    private List<String> osNames = new ArrayList<String>();
    private String librarySource;
    private String libraryPath;
    private List<String> processors = new ArrayList<String>();
    private List<VersionRange> osVersions = new ArrayList<VersionRange>();
    private List<String> languages = new ArrayList<String>();
    private String selectionFilter;
    private boolean optional;

    public NativeLibrary(List<String> osNames, String libraryPath, String librarySource) {
        if (libraryPath == null) {
            throw new IllegalArgumentException("Null library path: " + libraryPath);
        }
        if (osNames == null || osNames.isEmpty()) {
            throw new IllegalArgumentException("Illegal OS names: " + osNames);
        }
        if (librarySource == null) {
            throw new IllegalArgumentException("Null file privider: " + librarySource);
        }
        this.osNames = osNames;
        this.libraryPath = libraryPath;
        this.librarySource = librarySource;
    }

    public String getLibrarySource() {
        return this.librarySource;
    }

    public String getLibraryPath() {
        return this.libraryPath;
    }

    public List<String> getOsNames() {
        return Collections.unmodifiableList(this.osNames);
    }

    public List<VersionRange> getOsVersions() {
        return Collections.unmodifiableList(this.osVersions);
    }

    public void setOsVersions(List<VersionRange> osVersions) {
        this.osVersions = osVersions;
    }

    public List<String> getProcessors() {
        return Collections.unmodifiableList(this.processors);
    }

    public void setProcessors(List<String> processors) {
        this.processors = processors;
    }

    public void setLanguages(List<String> languages) {
        this.languages = languages;
    }

    public List<String> getLanguages() {
        return Collections.unmodifiableList(this.languages);
    }

    public String getSelectionFilter() {
        return this.selectionFilter;
    }

    public void setSelectionFilter(String selectionFilter) {
        this.selectionFilter = selectionFilter;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }
}

