/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.util;

import java.util.ArrayList;
import java.util.Collections;
import org.jboss.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

public final class ExportedPackageHelper {
    private static final Logger log = Logger.getLogger(ExportedPackageHelper.class);
    private PackageAdmin packageAdmin;

    public ExportedPackageHelper(BundleContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        ServiceReference sref = context.getServiceReference(PackageAdmin.class.getName());
        if (sref != null) {
            this.packageAdmin = (PackageAdmin)context.getService(sref);
        }
    }

    public boolean resolveBundle(Bundle bundle) {
        return this.packageAdmin != null ? this.packageAdmin.resolveBundles(new Bundle[]{bundle}) : false;
    }

    public boolean resolveBundles(Bundle[] bundles) {
        return this.packageAdmin != null ? this.packageAdmin.resolveBundles(bundles) : false;
    }

    public void logExportedPackages(Bundle bundle) {
        if (this.packageAdmin != null) {
            log.debug((Object)("Exported-Packages: " + bundle.getSymbolicName()));
            ExportedPackage[] exportedPackages = this.packageAdmin.getExportedPackages(bundle);
            if (exportedPackages != null) {
                ArrayList<String> packages = new ArrayList<String>();
                for (ExportedPackage exp : exportedPackages) {
                    packages.add("  " + exp.getName() + ";version=" + exp.getVersion());
                }
                Collections.sort(packages);
                for (String exp : packages) {
                    log.debug((Object)exp);
                }
            }
        }
    }
}

