/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.testing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.osgi.framework.Version;

public final class OSGiManifestBuilder
implements Asset {
    private StringWriter sw;
    private PrintWriter pw;
    private List<String> importPackages = new ArrayList<String>();
    private List<String> exportPackages = new ArrayList<String>();
    private List<String> dynamicImportPackages = new ArrayList<String>();
    private List<String> requiredBundles = new ArrayList<String>();

    public static OSGiManifestBuilder newInstance() {
        return new OSGiManifestBuilder();
    }

    private OSGiManifestBuilder() {
        this.sw = new StringWriter();
        this.pw = new PrintWriter(this.sw);
        this.pw.println(Attributes.Name.MANIFEST_VERSION + ": 1.0");
    }

    public OSGiManifestBuilder addBundleManifestVersion(int version) {
        this.pw.println("Bundle-ManifestVersion: " + version);
        return this;
    }

    public OSGiManifestBuilder addBundleSymbolicName(String symbolicName) {
        this.pw.println("Bundle-SymbolicName: " + symbolicName);
        return this;
    }

    public OSGiManifestBuilder addBundleVersion(Version version) {
        this.pw.println("Bundle-Version: " + version);
        return this;
    }

    public OSGiManifestBuilder addBundleVersion(String version) {
        return this.addBundleVersion(Version.parseVersion((String)version));
    }

    public OSGiManifestBuilder addBundleActivator(Class<?> bundleActivator) {
        return this.addBundleActivator(bundleActivator.getName());
    }

    public OSGiManifestBuilder addBundleActivator(String bundleActivator) {
        this.pw.println("Bundle-Activator: " + bundleActivator);
        return this;
    }

    public OSGiManifestBuilder addRequireBundle(String requiredBundle) {
        this.requiredBundles.add(requiredBundle);
        return this;
    }

    public OSGiManifestBuilder addImportPackages(Class<?> ... packages) {
        for (Class<?> aux : packages) {
            this.importPackages.add(aux.getPackage().getName());
        }
        return this;
    }

    public OSGiManifestBuilder addImportPackages(String ... packages) {
        for (String aux : packages) {
            this.importPackages.add(aux);
        }
        return this;
    }

    public OSGiManifestBuilder addDynamicImportPackages(String ... packages) {
        for (String aux : packages) {
            this.dynamicImportPackages.add(aux);
        }
        return this;
    }

    public OSGiManifestBuilder addExportPackages(Class<?> ... packages) {
        for (Class<?> aux : packages) {
            this.exportPackages.add(aux.getPackage().getName());
        }
        return this;
    }

    public OSGiManifestBuilder addExportPackages(String ... packages) {
        for (String aux : packages) {
            this.exportPackages.add(aux);
        }
        return this;
    }

    public OSGiManifestBuilder addManifestHeader(String key, String value) {
        this.pw.println(key + ": " + value);
        return this;
    }

    public Manifest getManifest() {
        int i;
        if (this.requiredBundles.size() > 0) {
            this.pw.print("Require-Bundle: ");
            for (i = 0; i < this.requiredBundles.size(); ++i) {
                if (i > 0) {
                    this.pw.print(",");
                }
                this.pw.print(this.requiredBundles.get(i));
            }
            this.pw.println();
        }
        if (this.exportPackages.size() > 0) {
            this.pw.print("Export-Package: ");
            for (i = 0; i < this.exportPackages.size(); ++i) {
                if (i > 0) {
                    this.pw.print(",");
                }
                this.pw.print(this.exportPackages.get(i));
            }
            this.pw.println();
        }
        if (this.importPackages.size() > 0) {
            this.pw.print("Import-Package: ");
            for (i = 0; i < this.importPackages.size(); ++i) {
                if (i > 0) {
                    this.pw.print(",");
                }
                this.pw.print(this.importPackages.get(i));
            }
            this.pw.println();
        }
        if (this.dynamicImportPackages.size() > 0) {
            this.pw.print("DynamicImport-Package: ");
            for (i = 0; i < this.dynamicImportPackages.size(); ++i) {
                if (i > 0) {
                    this.pw.print(",");
                }
                this.pw.print(this.dynamicImportPackages.get(i));
            }
            this.pw.println();
        }
        try {
            Manifest manifest = new Manifest(new ByteArrayInputStream(this.sw.toString().getBytes()));
            return manifest;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot create manifest", ex);
        }
    }

    public InputStream openStream() {
        Manifest manifest = this.getManifest();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            manifest.write(baos);
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot provide manifest InputStream", ex);
        }
    }
}

