/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.xml;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import org.jboss.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.xml.XMLParserActivator;

public class XMLParserActivatorExt
extends XMLParserActivator {
    private static final Logger log = Logger.getLogger(XMLParserActivatorExt.class);

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.logSAXParserFactory(context);
        this.logDOMParserFactory(context);
    }

    public void setDOMProperties(DocumentBuilderFactory factory, Hashtable props) {
        super.setDOMProperties(factory, props);
        boolean xinclude = true;
        Boolean validating = (Boolean)props.get("parser.validating");
        Boolean namespaceaware = (Boolean)props.get("parser.namespaceAware");
        factory.setValidating(validating);
        factory.setNamespaceAware(namespaceaware);
        factory.setXIncludeAware(true);
        try {
            factory.newDocumentBuilder();
        }
        catch (Exception pce_inc) {
            xinclude = false;
        }
        factory.setXIncludeAware(xinclude);
        props.put("parser.xincludeAware", new Boolean(xinclude));
        props.put("provider", "jboss.osgi");
    }

    public void setSAXProperties(SAXParserFactory factory, Hashtable props) {
        super.setSAXProperties(factory, props);
        boolean xinclude = true;
        Boolean validating = (Boolean)props.get("parser.validating");
        Boolean namespaceaware = (Boolean)props.get("parser.namespaceAware");
        factory.setValidating(validating);
        factory.setNamespaceAware(namespaceaware);
        factory.setXIncludeAware(true);
        try {
            factory.newSAXParser();
        }
        catch (Exception pce_inc) {
            xinclude = false;
        }
        factory.setXIncludeAware(xinclude);
        props.put("parser.xincludeAware", new Boolean(xinclude));
        props.put("provider", "jboss.osgi");
    }

    private void logSAXParserFactory(BundleContext context) throws InvalidSyntaxException {
        ServiceReference[] saxRefs = context.getServiceReferences(SAXParserFactory.class.getName(), null);
        if (saxRefs != null) {
            for (ServiceReference sref : saxRefs) {
                Object factory = context.getService(sref);
                log.debug((Object)("SAXParserFactory: " + factory.getClass().getName()));
                for (String key : sref.getPropertyKeys()) {
                    List<String> value = sref.getProperty(key);
                    if (key.equals("objectClass")) {
                        value = Arrays.asList((String[])value);
                    }
                    log.debug((Object)("   " + key + "=" + value));
                }
            }
        } else {
            log.warn((Object)"No SAXParserFactory registered");
        }
    }

    private void logDOMParserFactory(BundleContext context) throws InvalidSyntaxException {
        ServiceReference[] domRefs = context.getServiceReferences(DocumentBuilderFactory.class.getName(), null);
        if (domRefs != null) {
            for (ServiceReference sref : domRefs) {
                Object factory = context.getService(sref);
                log.debug((Object)("DocumentBuilderFactory: " + factory.getClass().getName()));
                for (String key : sref.getPropertyKeys()) {
                    List<String> value = sref.getProperty(key);
                    if (key.equals("objectClass")) {
                        value = Arrays.asList((String[])value);
                    }
                    log.debug((Object)("   " + key + "=" + value));
                }
            }
        } else {
            log.warn((Object)"No DocumentBuilderFactory registered");
        }
    }
}

