/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.deployment.internal;

import java.util.List;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.DeploymentRegistryService;
import org.jboss.osgi.deployment.interceptor.AbstractLifecycleInterceptorService;
import org.jboss.osgi.deployment.interceptor.InvocationContext;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptor;
import org.jboss.osgi.deployment.internal.InvocationContextImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifecycleInterceptorServiceImpl
extends AbstractLifecycleInterceptorService {
    public LifecycleInterceptorServiceImpl(BundleContext context) {
        super(context);
    }

    @Override
    public List<LifecycleInterceptor> getInterceptorChain() {
        return super.getInterceptorChain();
    }

    @Override
    protected InvocationContext getInvocationContext(Bundle bundle) {
        DeploymentRegistryService service = this.getDeploymentRegistryService();
        Deployment dep = service.getDeployment(bundle.getSymbolicName(), bundle.getVersion());
        if (dep == null) {
            throw new IllegalStateException("Cannot get deployment for: " + bundle);
        }
        return new InvocationContextImpl(this.getSystemContext(), bundle, dep.getRoot(), dep);
    }

    private DeploymentRegistryService getDeploymentRegistryService() {
        BundleContext context = this.getSystemContext();
        ServiceReference sref = context.getServiceReference(DeploymentRegistryService.class.getName());
        if (sref == null) {
            throw new IllegalStateException("Cannot obtain deployment registry service");
        }
        return (DeploymentRegistryService)context.getService(sref);
    }
}

