/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.resolver;

import java.net.URL;
import java.util.Enumeration;
import org.apache.felix.framework.capabilityset.Capability;
import org.apache.felix.framework.capabilityset.Requirement;
import org.apache.felix.framework.resolver.Module;
import org.apache.felix.framework.resolver.ResourceNotFoundException;
import org.apache.felix.framework.resolver.Wire;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.manifestparser.CapabilityImpl;

public class WireImpl
implements Wire {
    private final Module m_importer;
    private final Requirement m_req;
    private final Module m_exporter;
    private final Capability m_cap;

    public WireImpl(Module importer, Requirement ip, Module exporter, Capability ep) {
        this.m_importer = importer;
        this.m_req = ip;
        this.m_exporter = exporter;
        this.m_cap = ep;
    }

    @Override
    public Module getImporter() {
        return this.m_importer;
    }

    @Override
    public Requirement getRequirement() {
        return this.m_req;
    }

    @Override
    public Module getExporter() {
        return this.m_exporter;
    }

    @Override
    public Capability getCapability() {
        return this.m_cap;
    }

    public String toString() {
        return this.m_req + " -> " + "[" + this.m_exporter + "]";
    }

    @Override
    public boolean hasPackage(String pkgName) {
        return this.m_cap.getNamespace().equals("package") && this.m_cap.getAttribute("package").getValue().equals(pkgName);
    }

    @Override
    public Class getClass(String name) throws ClassNotFoundException {
        Class clazz = null;
        String pkgName = Util.getClassPackage(name);
        if (this.m_cap.getNamespace().equals("package") && this.m_cap.getAttribute("package").getValue().equals(pkgName)) {
            if (((CapabilityImpl)this.m_cap).isIncluded(name)) {
                clazz = this.m_exporter.getClassByDelegation(name);
            }
            if (clazz == null) {
                throw new ClassNotFoundException(name);
            }
        }
        return clazz;
    }

    @Override
    public URL getResource(String name) throws ResourceNotFoundException {
        URL url = null;
        String pkgName = Util.getResourcePackage(name);
        if (this.m_cap.getNamespace().equals("package") && this.m_cap.getAttribute("package").getValue().equals(pkgName) && (url = this.m_exporter.getResourceByDelegation(name)) == null) {
            throw new ResourceNotFoundException(name);
        }
        return url;
    }

    @Override
    public Enumeration getResources(String name) throws ResourceNotFoundException {
        Enumeration urls = null;
        String pkgName = Util.getResourcePackage(name);
        if (this.m_cap.getNamespace().equals("package") && this.m_cap.getAttribute("package").getValue().equals(pkgName) && (urls = this.m_exporter.getResourcesByDelegation(name)) == null) {
            throw new ResourceNotFoundException(name);
        }
        return urls;
    }
}

