/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.util.manifestparser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.capabilityset.Attribute;
import org.apache.felix.framework.capabilityset.Capability;
import org.apache.felix.framework.capabilityset.Directive;
import org.apache.felix.framework.capabilityset.Requirement;
import org.apache.felix.framework.resolver.Module;
import org.apache.felix.framework.util.VersionRange;
import org.apache.felix.framework.util.manifestparser.CapabilityImpl;
import org.apache.felix.framework.util.manifestparser.ParsedHeaderClause;
import org.apache.felix.framework.util.manifestparser.R4Library;
import org.apache.felix.framework.util.manifestparser.R4LibraryClause;
import org.apache.felix.framework.util.manifestparser.RequirementImpl;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class ManifestParser {
    private final Logger m_logger;
    private final Map m_configMap;
    private final Map m_headerMap;
    private volatile int m_activationPolicy = 0;
    private volatile String m_activationIncludeDir;
    private volatile String m_activationExcludeDir;
    private volatile boolean m_isExtension = false;
    private volatile String m_bundleSymbolicName;
    private volatile Version m_bundleVersion;
    private volatile List<Capability> m_capabilities;
    private volatile List<Requirement> m_requirements;
    private volatile List<Requirement> m_dynamicRequirements;
    private volatile List<R4LibraryClause> m_libraryClauses;
    private volatile boolean m_libraryHeadersOptional = false;
    public static final int CLAUSE_PATHS_INDEX = 0;
    public static final int CLAUSE_DIRECTIVES_INDEX = 1;
    public static final int CLAUSE_ATTRIBUTES_INDEX = 2;

    public ManifestParser(Logger logger, Map configMap, Module owner, Map headerMap) throws BundleException {
        Capability moduleCap;
        this.m_logger = logger;
        this.m_configMap = configMap;
        this.m_headerMap = headerMap;
        String manifestVersion = ManifestParser.getManifestVersion(this.m_headerMap);
        if (manifestVersion != null && !manifestVersion.equals("2")) {
            throw new BundleException("Unknown 'Bundle-ManifestVersion' value: " + manifestVersion);
        }
        ArrayList<Capability> capList = new ArrayList<Capability>();
        this.m_bundleVersion = Version.emptyVersion;
        if (headerMap.get("Bundle-Version") != null) {
            try {
                this.m_bundleVersion = Version.parseVersion((String)((String)headerMap.get("Bundle-Version")));
            }
            catch (RuntimeException ex) {
                if (this.getManifestVersion().equals("2")) {
                    throw ex;
                }
                this.m_bundleVersion = Version.emptyVersion;
            }
        }
        if ((moduleCap = ManifestParser.parseBundleSymbolicName(owner, this.m_headerMap)) != null) {
            this.m_bundleSymbolicName = (String)moduleCap.getAttribute("bundle-symbolic-name").getValue();
            if (headerMap.get("Fragment-Host") == null) {
                capList.add(moduleCap);
                capList.add(new CapabilityImpl(owner, "host", new ArrayList<Directive>(0), ((CapabilityImpl)moduleCap).getAttributes()));
            }
        }
        if (this.getManifestVersion().equals("2") && this.m_bundleSymbolicName == null) {
            throw new BundleException("R4 bundle manifests must include bundle symbolic name.");
        }
        List<Requirement> hostReqs = ManifestParser.parseFragmentHost(this.m_logger, owner, this.m_headerMap);
        List<ParsedHeaderClause> requireClauses = ManifestParser.parseStandardHeader((String)headerMap.get("Require-Bundle"));
        requireClauses = ManifestParser.normalizeRequireClauses(this.m_logger, requireClauses, this.getManifestVersion());
        List<Requirement> requireReqs = ManifestParser.convertRequires(requireClauses, owner);
        List<ParsedHeaderClause> importClauses = ManifestParser.parseStandardHeader((String)headerMap.get("Import-Package"));
        importClauses = ManifestParser.normalizeImportClauses(this.m_logger, importClauses, this.getManifestVersion());
        List<Requirement> importReqs = ManifestParser.convertImports(importClauses, owner);
        List<ParsedHeaderClause> dynamicClauses = ManifestParser.parseStandardHeader((String)headerMap.get("DynamicImport-Package"));
        dynamicClauses = ManifestParser.normalizeDynamicImportClauses(this.m_logger, dynamicClauses, this.getManifestVersion());
        this.m_dynamicRequirements = ManifestParser.convertImports(dynamicClauses, owner);
        List<ParsedHeaderClause> exportClauses = ManifestParser.parseStandardHeader((String)headerMap.get("Export-Package"));
        exportClauses = ManifestParser.normalizeExportClauses(logger, exportClauses, this.getManifestVersion(), this.m_bundleSymbolicName, this.m_bundleVersion);
        List<Capability> exportCaps = ManifestParser.convertExports(exportClauses, owner);
        if (!this.getManifestVersion().equals("2")) {
            List<ParsedHeaderClause> implicitClauses = ManifestParser.calculateImplicitImports(exportCaps, importClauses);
            importReqs.addAll(ManifestParser.convertImports(implicitClauses, owner));
            ArrayList<ParsedHeaderClause> allImportClauses = new ArrayList<ParsedHeaderClause>(implicitClauses.size() + importClauses.size());
            allImportClauses.addAll(importClauses);
            allImportClauses.addAll(implicitClauses);
            exportCaps = ManifestParser.calculateImplicitUses(exportCaps, allImportClauses);
        }
        this.m_capabilities = new ArrayList<Capability>(capList.size() + exportCaps.size());
        this.m_capabilities.addAll(capList);
        this.m_capabilities.addAll(exportCaps);
        this.m_requirements = new ArrayList<Requirement>(importReqs.size() + requireReqs.size() + hostReqs.size());
        this.m_requirements.addAll(importReqs);
        this.m_requirements.addAll(requireReqs);
        this.m_requirements.addAll(hostReqs);
        this.m_libraryClauses = ManifestParser.parseLibraryStrings(this.m_logger, ManifestParser.parseDelimitedString((String)this.m_headerMap.get("Bundle-NativeCode"), ","));
        if (this.m_libraryClauses.size() > 0 && this.m_libraryClauses.get(this.m_libraryClauses.size() - 1).getLibraryEntries() == null) {
            this.m_libraryHeadersOptional = true;
            this.m_libraryClauses.remove(this.m_libraryClauses.size() - 1);
        }
        this.parseActivationPolicy(headerMap);
        this.m_isExtension = ManifestParser.checkExtensionBundle(headerMap);
    }

    private static List<ParsedHeaderClause> normalizeImportClauses(Logger logger, List<ParsedHeaderClause> clauses, String mv) throws BundleException {
        int clauseIdx;
        HashMap<String, Attribute> attrMap = new HashMap<String, Attribute>();
        for (int clauseIdx2 = 0; clauseIdx2 < clauses.size(); ++clauseIdx2) {
            attrMap.clear();
            for (int attrIdx = 0; attrIdx < clauses.get((int)clauseIdx2).m_attrs.size(); ++attrIdx) {
                Attribute attr = clauses.get((int)clauseIdx2).m_attrs.get(attrIdx);
                attrMap.put(attr.getName(), attr);
            }
            Attribute v = (Attribute)attrMap.get("version");
            Attribute sv = (Attribute)attrMap.get("specification-version");
            if (v != null && sv != null && !((String)v.getValue()).trim().equals(((String)sv.getValue()).trim())) {
                throw new IllegalArgumentException("Both version and specification-version are specified, but they are not equal.");
            }
            if (v != null || sv != null) {
                attrMap.remove("specification-version");
                v = v == null ? sv : v;
                attrMap.put("version", new Attribute("version", VersionRange.parse(v.getValue().toString()), v.isMandatory()));
            }
            if ((v = (Attribute)attrMap.get("bundle-version")) != null) {
                attrMap.put("bundle-version", new Attribute("bundle-version", VersionRange.parse(v.getValue().toString()), v.isMandatory()));
            }
            clauses.get((int)clauseIdx2).m_attrs.clear();
            clauses.get((int)clauseIdx2).m_attrs.addAll(attrMap.values());
        }
        HashSet<String> dupeSet = new HashSet<String>();
        for (clauseIdx = 0; clauseIdx < clauses.size(); ++clauseIdx) {
            List<String> paths = clauses.get((int)clauseIdx).m_paths;
            for (int pathIdx = 0; pathIdx < paths.size(); ++pathIdx) {
                String pkgName = paths.get(pathIdx);
                if (!dupeSet.contains(pkgName)) {
                    if (pkgName.startsWith("java.")) {
                        throw new BundleException("Importing java.* packages not allowed: " + pkgName);
                    }
                    if (clauses.get((int)clauseIdx).m_paths.get(pathIdx).length() == 0) {
                        throw new BundleException("Imported package names cannot be zero length.");
                    }
                } else {
                    throw new BundleException("Duplicate import: " + pkgName);
                }
                dupeSet.add(pkgName);
            }
        }
        if (!mv.equals("2")) {
            for (clauseIdx = 0; clauseIdx < clauses.size(); ++clauseIdx) {
                if (clauses.get((int)clauseIdx).m_dirs.size() != 0) {
                    throw new BundleException("R3 imports cannot contain directives.");
                }
                if (clauses.get((int)clauseIdx).m_attrs.size() == 0) continue;
                Attribute pkgVersion = new Attribute("version", new VersionRange(Version.emptyVersion, true, null, true), false);
                for (int attrIdx = 0; attrIdx < clauses.get((int)clauseIdx).m_attrs.size(); ++attrIdx) {
                    if (clauses.get((int)clauseIdx).m_attrs.get(attrIdx).getName().equals("version")) {
                        pkgVersion = clauses.get((int)clauseIdx).m_attrs.get(attrIdx);
                        continue;
                    }
                    logger.log(2, "Unknown R3 import attribute: " + clauses.get((int)clauseIdx).m_attrs.get(attrIdx).getName());
                }
                ArrayList<Attribute> attrs = new ArrayList<Attribute>(1);
                attrs.add(pkgVersion);
                clauses.set(clauseIdx, new ParsedHeaderClause(clauses.get((int)clauseIdx).m_paths, clauses.get((int)clauseIdx).m_dirs, attrs));
            }
        }
        return clauses;
    }

    private static List<Requirement> convertImports(List<ParsedHeaderClause> clauses, Module owner) {
        ArrayList<Requirement> reqList = new ArrayList<Requirement>();
        for (int clauseIdx = 0; clauseIdx < clauses.size(); ++clauseIdx) {
            for (int pathIdx = 0; pathIdx < clauses.get((int)clauseIdx).m_paths.size(); ++pathIdx) {
                List<Attribute> attrs = clauses.get((int)clauseIdx).m_attrs;
                ArrayList<Attribute> newAttrs = new ArrayList<Attribute>(attrs.size() + 1);
                newAttrs.add(new Attribute("package", clauses.get((int)clauseIdx).m_paths.get(pathIdx), false));
                newAttrs.addAll(attrs);
                reqList.add(new RequirementImpl(owner, "package", clauses.get((int)clauseIdx).m_dirs, newAttrs));
            }
        }
        return reqList;
    }

    private static List<ParsedHeaderClause> normalizeDynamicImportClauses(Logger logger, List<ParsedHeaderClause> clauses, String mv) throws BundleException {
        int clauseIdx;
        HashMap<String, Attribute> attrMap = new HashMap<String, Attribute>();
        for (clauseIdx = 0; clauseIdx < clauses.size(); ++clauseIdx) {
            attrMap.clear();
            for (int attrIdx = 0; attrIdx < clauses.get((int)clauseIdx).m_attrs.size(); ++attrIdx) {
                Attribute attr = clauses.get((int)clauseIdx).m_attrs.get(attrIdx);
                attrMap.put(attr.getName(), attr);
            }
            Attribute v = (Attribute)attrMap.get("version");
            Attribute sv = (Attribute)attrMap.get("specification-version");
            if (v != null && sv != null && !((String)v.getValue()).trim().equals(((String)sv.getValue()).trim())) {
                throw new IllegalArgumentException("Both version and specification-version are specified, but they are not equal.");
            }
            if (v != null || sv != null) {
                attrMap.remove("specification-version");
                v = v == null ? sv : v;
                attrMap.put("version", new Attribute("version", VersionRange.parse(v.getValue().toString()), v.isMandatory()));
            }
            if ((v = (Attribute)attrMap.get("bundle-version")) != null) {
                attrMap.put("bundle-version", new Attribute("bundle-version", VersionRange.parse(v.getValue().toString()), v.isMandatory()));
            }
            clauses.get((int)clauseIdx).m_attrs.clear();
            clauses.get((int)clauseIdx).m_attrs.addAll(attrMap.values());
        }
        for (clauseIdx = 0; clauseIdx < clauses.size(); ++clauseIdx) {
            List<String> paths = clauses.get((int)clauseIdx).m_paths;
            for (int pathIdx = 0; pathIdx < paths.size(); ++pathIdx) {
                String pkgName = paths.get(pathIdx);
                if (pkgName.startsWith("java.")) {
                    throw new BundleException("Dynamically importing java.* packages not allowed: " + pkgName);
                }
                if (pkgName.equals("*") || !pkgName.endsWith("*") || pkgName.endsWith(".*")) continue;
                throw new BundleException("Partial package name wild carding is not allowed: " + pkgName);
            }
        }
        if (!mv.equals("2")) {
            for (clauseIdx = 0; clauseIdx < clauses.size(); ++clauseIdx) {
                if (clauses.get((int)clauseIdx).m_dirs.size() == 0) continue;
                throw new BundleException("R3 imports cannot contain directives.");
            }
        }
        return clauses;
    }

    private static List<ParsedHeaderClause> normalizeExportClauses(Logger logger, List<ParsedHeaderClause> clauses, String mv, String bsn, Version bv) throws BundleException {
        block14: {
            List<Attribute> attrs;
            int clauseIdx;
            block13: {
                for (int clauseIdx2 = 0; clauseIdx2 < clauses.size(); ++clauseIdx2) {
                    for (int pathIdx = 0; pathIdx < clauses.get((int)clauseIdx2).m_paths.size(); ++pathIdx) {
                        if (clauses.get((int)clauseIdx2).m_paths.get(pathIdx).startsWith("java.")) {
                            throw new BundleException("Exporting java.* packages not allowed: " + clauses.get((int)clauseIdx2).m_paths.get(pathIdx));
                        }
                        if (clauses.get((int)clauseIdx2).m_paths.get(pathIdx).length() != 0) continue;
                        throw new BundleException("Exported package names cannot be zero length.");
                    }
                }
                HashMap<String, Attribute> attrMap = new HashMap<String, Attribute>();
                for (clauseIdx = 0; clauseIdx < clauses.size(); ++clauseIdx) {
                    attrMap.clear();
                    for (int attrIdx = 0; attrIdx < clauses.get((int)clauseIdx).m_attrs.size(); ++attrIdx) {
                        Attribute attr = clauses.get((int)clauseIdx).m_attrs.get(attrIdx);
                        attrMap.put(attr.getName(), attr);
                    }
                    Attribute v = (Attribute)attrMap.get("version");
                    Attribute sv = (Attribute)attrMap.get("specification-version");
                    if (v != null && sv != null && !((String)v.getValue()).trim().equals(((String)sv.getValue()).trim())) {
                        throw new IllegalArgumentException("Both version and specification-version are specified, but they are not equal.");
                    }
                    if (v == null && sv == null) {
                        v = new Attribute("version", Version.emptyVersion, false);
                    }
                    if (v == null && sv == null) continue;
                    attrMap.remove("specification-version");
                    v = v == null ? sv : v;
                    attrMap.put("version", new Attribute("version", Version.parseVersion((String)v.getValue().toString()), v.isMandatory()));
                    clauses.get((int)clauseIdx).m_attrs.clear();
                    clauses.get((int)clauseIdx).m_attrs.addAll(attrMap.values());
                }
                if (!mv.equals("2")) break block13;
                for (clauseIdx = 0; clauseIdx < clauses.size(); ++clauseIdx) {
                    attrs = clauses.get((int)clauseIdx).m_attrs;
                    for (int attrIdx = 0; attrIdx < attrs.size(); ++attrIdx) {
                        if (!attrs.get(attrIdx).getName().equals("bundle-version") && !attrs.get(attrIdx).getName().equals("bundle-symbolic-name")) continue;
                        throw new BundleException("Exports must not specify bundle symbolic name or bundle version.");
                    }
                    attrs.add(new Attribute("bundle-symbolic-name", bsn, false));
                    attrs.add(new Attribute("bundle-version", bv, false));
                    ((ArrayList)attrs).trimToSize();
                }
                break block14;
            }
            if (mv.equals("2")) break block14;
            for (clauseIdx = 0; clauseIdx < clauses.size(); ++clauseIdx) {
                if (clauses.get((int)clauseIdx).m_dirs.size() != 0) {
                    throw new BundleException("R3 exports cannot contain directives.");
                }
                if (clauses.get((int)clauseIdx).m_attrs.size() == 0) continue;
                attrs = clauses.get((int)clauseIdx).m_attrs;
                Attribute pkgVersion = new Attribute("version", Version.emptyVersion, false);
                for (int attrIdx = 0; attrIdx < attrs.size(); ++attrIdx) {
                    if (attrs.get(attrIdx).getName().equals("version")) {
                        pkgVersion = attrs.get(attrIdx);
                        continue;
                    }
                    logger.log(2, "Unknown R3 export attribute: " + attrs.get(attrIdx).getName());
                }
                ArrayList<Attribute> newAttrs = new ArrayList<Attribute>(2);
                newAttrs.add(pkgVersion);
                clauses.set(clauseIdx, new ParsedHeaderClause(clauses.get((int)clauseIdx).m_paths, clauses.get((int)clauseIdx).m_dirs, newAttrs));
            }
        }
        return clauses;
    }

    public String getManifestVersion() {
        String manifestVersion = ManifestParser.getManifestVersion(this.m_headerMap);
        return manifestVersion == null ? "1" : manifestVersion;
    }

    private static String getManifestVersion(Map headerMap) {
        String manifestVersion = (String)headerMap.get("Bundle-ManifestVersion");
        return manifestVersion == null ? null : manifestVersion.trim();
    }

    public int getActivationPolicy() {
        return this.m_activationPolicy;
    }

    public String getActivationIncludeDirective() {
        return this.m_activationIncludeDir;
    }

    public String getActivationExcludeDirective() {
        return this.m_activationExcludeDir;
    }

    public boolean isExtension() {
        return this.m_isExtension;
    }

    public String getSymbolicName() {
        return this.m_bundleSymbolicName;
    }

    public Version getBundleVersion() {
        return this.m_bundleVersion;
    }

    public List<Capability> getCapabilities() {
        return this.m_capabilities;
    }

    public List<Requirement> getRequirements() {
        return this.m_requirements;
    }

    public List<Requirement> getDynamicRequirements() {
        return this.m_dynamicRequirements;
    }

    public List<R4LibraryClause> getLibraryClauses() {
        return this.m_libraryClauses;
    }

    public List<R4Library> getLibraries() {
        ArrayList<R4Library> libs = null;
        try {
            R4LibraryClause clause = this.getSelectedLibraryClause();
            if (clause != null) {
                String[] entries = clause.getLibraryEntries();
                libs = new ArrayList(entries.length);
                int current = 0;
                for (int i = 0; i < entries.length; ++i) {
                    String name = this.getName(entries[i]);
                    boolean found = false;
                    for (int j = 0; !found && j < current; ++j) {
                        found = this.getName(entries[j]).equals(name);
                    }
                    if (found) continue;
                    libs.add(new R4Library(clause.getLibraryEntries()[i], clause.getOSNames(), clause.getProcessors(), clause.getOSVersions(), clause.getLanguages(), clause.getSelectionFilter()));
                }
                libs.trimToSize();
            }
        }
        catch (Exception ex) {
            libs = new ArrayList<R4Library>(0);
        }
        return libs;
    }

    private String getName(String path) {
        int idx = path.lastIndexOf(47);
        if (idx > -1) {
            return path.substring(idx);
        }
        return path;
    }

    private R4LibraryClause getSelectedLibraryClause() throws BundleException {
        if (this.m_libraryClauses != null && this.m_libraryClauses.size() > 0) {
            ArrayList<R4LibraryClause> clauseList = new ArrayList<R4LibraryClause>();
            for (int i = 0; i < this.m_libraryClauses.size(); ++i) {
                if (!this.m_libraryClauses.get(i).match(this.m_configMap)) continue;
                clauseList.add(this.m_libraryClauses.get(i));
            }
            int selected = 0;
            if (clauseList.size() == 0) {
                if (this.m_libraryHeadersOptional) {
                    return null;
                }
                throw new BundleException("Unable to select a native library clause.");
            }
            if (clauseList.size() == 1) {
                selected = 0;
            } else if (clauseList.size() > 1) {
                selected = this.firstSortedClause(clauseList);
            }
            return (R4LibraryClause)clauseList.get(selected);
        }
        return null;
    }

    private int firstSortedClause(List clauseList) {
        VersionRange range;
        int k;
        String[] osversions;
        int index;
        int i;
        ArrayList<String> indexList = new ArrayList<String>();
        ArrayList<String> selection = new ArrayList<String>();
        for (int i2 = 0; i2 < clauseList.size(); ++i2) {
            indexList.add("" + i2);
        }
        Version osVersionRangeMaxFloor = new Version(0, 0, 0);
        for (i = 0; i < indexList.size(); ++i) {
            index = Integer.parseInt(indexList.get(i).toString());
            osversions = ((R4LibraryClause)clauseList.get(index)).getOSVersions();
            if (osversions != null) {
                selection.add("" + indexList.get(i));
            }
            for (k = 0; osversions != null && k < osversions.length; ++k) {
                range = VersionRange.parse(osversions[k]);
                if (range.getFloor().compareTo((Object)osVersionRangeMaxFloor) < 0) continue;
                osVersionRangeMaxFloor = range.getFloor();
            }
        }
        if (selection.size() == 1) {
            return Integer.parseInt(selection.get(0).toString());
        }
        if (selection.size() > 1) {
            indexList = selection;
            selection = new ArrayList();
            for (i = 0; i < indexList.size(); ++i) {
                index = Integer.parseInt(indexList.get(i).toString());
                osversions = ((R4LibraryClause)clauseList.get(index)).getOSVersions();
                for (k = 0; k < osversions.length; ++k) {
                    range = VersionRange.parse(osversions[k]);
                    if (range.getFloor().compareTo((Object)osVersionRangeMaxFloor) < 0) continue;
                    selection.add("" + indexList.get(i));
                }
            }
        }
        if (selection.size() == 0) {
            selection.clear();
            indexList.clear();
            for (i = 0; i < clauseList.size(); ++i) {
                indexList.add("" + i);
            }
        } else {
            if (selection.size() == 1) {
                return Integer.parseInt(selection.get(0).toString());
            }
            indexList = selection;
            selection.clear();
        }
        for (i = 0; i < indexList.size(); ++i) {
            index = Integer.parseInt(indexList.get(i).toString());
            if (((R4LibraryClause)clauseList.get(index)).getLanguages() == null) continue;
            selection.add("" + indexList.get(i));
        }
        if (selection.size() == 0) {
            return 0;
        }
        return Integer.parseInt(selection.get(0).toString());
    }

    private static List<ParsedHeaderClause> calculateImplicitImports(List<Capability> exports, List<ParsedHeaderClause> imports) throws BundleException {
        ArrayList<ParsedHeaderClause> clauseList = new ArrayList<ParsedHeaderClause>();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int impIdx = 0; impIdx < imports.size(); ++impIdx) {
            for (int pathIdx = 0; pathIdx < imports.get((int)impIdx).m_paths.size(); ++pathIdx) {
                map.put(imports.get((int)impIdx).m_paths.get(pathIdx), imports.get((int)impIdx).m_paths.get(pathIdx));
            }
        }
        for (int i = 0; i < exports.size(); ++i) {
            if (map.get(exports.get(i).getAttribute("package").getValue()) != null) continue;
            ArrayList<Attribute> attrs = new ArrayList<Attribute>(exports.get(i).getAttributes());
            for (int attrIdx = 0; attrs != null && attrIdx < attrs.size(); ++attrIdx) {
                if (!((Attribute)attrs.get(attrIdx)).getName().equals("version")) continue;
                attrs.set(attrIdx, new Attribute(((Attribute)attrs.get(attrIdx)).getName(), VersionRange.parse(((Attribute)attrs.get(attrIdx)).getValue().toString()), ((Attribute)attrs.get(attrIdx)).isMandatory()));
            }
            ArrayList<String> paths = new ArrayList<String>();
            paths.add((String)exports.get(i).getAttribute("package").getValue());
            clauseList.add(new ParsedHeaderClause(paths, new ArrayList<Directive>(0), attrs));
        }
        return clauseList;
    }

    private static List<Capability> calculateImplicitUses(List<Capability> exports, List<ParsedHeaderClause> imports) throws BundleException {
        String usesValue = "";
        for (int i = 0; i < imports.size(); ++i) {
            for (int pathIdx = 0; pathIdx < imports.get((int)i).m_paths.size(); ++pathIdx) {
                usesValue = usesValue + (usesValue.length() > 0 ? "," : "") + imports.get((int)i).m_paths.get(pathIdx);
            }
        }
        Directive uses = new Directive("uses", usesValue);
        for (int i = 0; i < exports.size(); ++i) {
            ArrayList<Directive> dirList = new ArrayList<Directive>(1);
            dirList.add(uses);
            exports.set(i, new CapabilityImpl(exports.get(i).getModule(), "package", dirList, exports.get(i).getAttributes()));
        }
        return exports;
    }

    private static boolean checkExtensionBundle(Map headerMap) throws BundleException {
        Directive extension = ManifestParser.parseExtensionBundleHeader((String)headerMap.get("Fragment-Host"));
        if (extension != null) {
            if (!"framework".equals(extension.getValue()) && !"bootclasspath".equals(extension.getValue())) {
                throw new BundleException("Extension bundle must have either 'extension:=framework' or 'extension:=bootclasspath'");
            }
            if (headerMap.containsKey("Import-Package") || headerMap.containsKey("Require-Bundle") || headerMap.containsKey("Bundle-NativeCode") || headerMap.containsKey("DynamicImport-Package") || headerMap.containsKey("Bundle-Activator")) {
                throw new BundleException("Invalid extension bundle manifest");
            }
            return true;
        }
        return false;
    }

    private static Capability parseBundleSymbolicName(Module owner, Map headerMap) throws BundleException {
        List<ParsedHeaderClause> clauses = ManifestParser.parseStandardHeader((String)headerMap.get("Bundle-SymbolicName"));
        if (clauses.size() > 0) {
            if (clauses.size() > 1) {
                throw new BundleException("Cannot have multiple symbolic names: " + headerMap.get("Bundle-SymbolicName"));
            }
            if (clauses.get((int)0).m_paths.size() > 1) {
                throw new BundleException("Cannot have multiple symbolic names: " + headerMap.get("Bundle-SymbolicName"));
            }
            Version bundleVersion = Version.emptyVersion;
            if (headerMap.get("Bundle-Version") != null) {
                try {
                    bundleVersion = Version.parseVersion((String)((String)headerMap.get("Bundle-Version")));
                }
                catch (RuntimeException ex) {
                    String mv = ManifestParser.getManifestVersion(headerMap);
                    if (mv != null) {
                        throw ex;
                    }
                    bundleVersion = Version.emptyVersion;
                }
            }
            String symName = clauses.get((int)0).m_paths.get(0);
            ArrayList<Attribute> attrs = new ArrayList<Attribute>(2);
            attrs.add(new Attribute("bundle-symbolic-name", symName, false));
            attrs.add(new Attribute("bundle-version", bundleVersion, false));
            return new CapabilityImpl(owner, "module", clauses.get((int)0).m_dirs, attrs);
        }
        return null;
    }

    private static List<Requirement> parseFragmentHost(Logger logger, Module owner, Map headerMap) throws BundleException {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        String mv = ManifestParser.getManifestVersion(headerMap);
        if (mv != null && mv.equals("2")) {
            List<ParsedHeaderClause> clauses = ManifestParser.parseStandardHeader((String)headerMap.get("Fragment-Host"));
            if (clauses.size() > 0) {
                if (clauses.size() > 1) {
                    throw new BundleException("Fragments cannot have multiple hosts: " + headerMap.get("Fragment-Host"));
                }
                if (clauses.get((int)0).m_paths.size() > 1) {
                    throw new BundleException("Fragments cannot have multiple hosts: " + headerMap.get("Fragment-Host"));
                }
                for (int attrIdx = 0; attrIdx < clauses.get((int)0).m_attrs.size(); ++attrIdx) {
                    Attribute attr = clauses.get((int)0).m_attrs.get(attrIdx);
                    if (!attr.getName().equals("bundle-version")) continue;
                    clauses.get((int)0).m_attrs.set(attrIdx, new Attribute("bundle-version", VersionRange.parse(attr.getValue().toString()), attr.isMandatory()));
                }
                List<Attribute> attrs = clauses.get((int)0).m_attrs;
                ArrayList<Attribute> newAttrs = new ArrayList<Attribute>(attrs.size() + 1);
                newAttrs.add(new Attribute("bundle-symbolic-name", clauses.get((int)0).m_paths.get(0), false));
                newAttrs.addAll(attrs);
                reqs.add(new RequirementImpl(owner, "host", clauses.get((int)0).m_dirs, newAttrs));
            }
        } else if (headerMap.get("Fragment-Host") != null) {
            String s = (String)headerMap.get("Bundle-SymbolicName");
            s = s == null ? (String)headerMap.get("Bundle-Name") : s;
            s = s == null ? headerMap.toString() : s;
            logger.log(2, "Only R4 bundles can be fragments: " + s);
        }
        return reqs;
    }

    public static List<Capability> parseExportHeader(Logger logger, Module owner, String header, String bsn, Version bv) {
        List<Capability> caps = null;
        try {
            List<ParsedHeaderClause> exportClauses = ManifestParser.parseStandardHeader(header);
            exportClauses = ManifestParser.normalizeExportClauses(logger, exportClauses, "2", bsn, bv);
            caps = ManifestParser.convertExports(exportClauses, owner);
        }
        catch (BundleException ex) {
            caps = null;
        }
        return caps;
    }

    private static List<Capability> convertExports(List<ParsedHeaderClause> clauses, Module owner) {
        ArrayList<Capability> capList = new ArrayList<Capability>();
        for (int clauseIdx = 0; clauseIdx < clauses.size(); ++clauseIdx) {
            for (int pathIdx = 0; pathIdx < clauses.get((int)clauseIdx).m_paths.size(); ++pathIdx) {
                List<Attribute> attrs = clauses.get((int)clauseIdx).m_attrs;
                ArrayList<Attribute> newAttrs = new ArrayList<Attribute>(attrs.size() + 1);
                newAttrs.add(new Attribute("package", clauses.get((int)clauseIdx).m_paths.get(pathIdx), false));
                newAttrs.addAll(attrs);
                capList.add(new CapabilityImpl(owner, "package", clauses.get((int)clauseIdx).m_dirs, newAttrs));
            }
        }
        return capList;
    }

    private static List<ParsedHeaderClause> normalizeRequireClauses(Logger logger, List<ParsedHeaderClause> clauses, String mv) {
        if (!mv.equals("2")) {
            clauses.clear();
        } else {
            for (int clauseIdx = 0; clauseIdx < clauses.size(); ++clauseIdx) {
                for (int attrIdx = 0; attrIdx < clauses.get((int)clauseIdx).m_attrs.size(); ++attrIdx) {
                    Attribute attr = clauses.get((int)clauseIdx).m_attrs.get(attrIdx);
                    if (!attr.getName().equals("bundle-version")) continue;
                    clauses.get((int)clauseIdx).m_attrs.set(attrIdx, new Attribute("bundle-version", VersionRange.parse(attr.getValue().toString()), attr.isMandatory()));
                }
            }
        }
        return clauses;
    }

    private static List<Requirement> convertRequires(List<ParsedHeaderClause> clauses, Module owner) {
        ArrayList<Requirement> reqList = new ArrayList<Requirement>();
        for (int clauseIdx = 0; clauseIdx < clauses.size(); ++clauseIdx) {
            List<Attribute> attrs = clauses.get((int)clauseIdx).m_attrs;
            for (int pathIdx = 0; pathIdx < clauses.get((int)clauseIdx).m_paths.size(); ++pathIdx) {
                ArrayList<Attribute> newAttrs = new ArrayList<Attribute>(attrs.size() + 1);
                newAttrs.add(new Attribute("bundle-symbolic-name", clauses.get((int)clauseIdx).m_paths.get(pathIdx), false));
                newAttrs.addAll(attrs);
                reqList.add(new RequirementImpl(owner, "module", clauses.get((int)clauseIdx).m_dirs, newAttrs));
            }
        }
        return reqList;
    }

    public static Directive parseExtensionBundleHeader(String header) throws BundleException {
        List<ParsedHeaderClause> clauses = ManifestParser.parseStandardHeader(header);
        Directive result = null;
        if (clauses.size() == 1) {
            List<Directive> dirs = clauses.get((int)0).m_dirs;
            for (int dirIdx = 0; result == null && dirIdx < dirs.size(); ++dirIdx) {
                if (!"extension".equals(dirs.get(dirIdx).getName())) continue;
                if ("org.apache.felix.framework".equals(clauses.get((int)0).m_paths.get(0)) || "system.bundle".equals(clauses.get((int)0).m_paths.get(0))) {
                    result = dirs.get(dirIdx);
                    continue;
                }
                throw new BundleException("Only the system bundle can have extension bundles.");
            }
        }
        return result;
    }

    private void parseActivationPolicy(Map headerMap) {
        this.m_activationPolicy = 0;
        List<ParsedHeaderClause> clauses = ManifestParser.parseStandardHeader((String)headerMap.get("Bundle-ActivationPolicy"));
        if (clauses.size() > 0) {
            for (int clauseIdx = 0; clauseIdx < clauses.get((int)0).m_paths.size(); ++clauseIdx) {
                if (!clauses.get((int)0).m_paths.get(clauseIdx).equals("lazy")) continue;
                this.m_activationPolicy = 1;
                for (int dirIdx = 0; dirIdx < clauses.get((int)0).m_dirs.size(); ++dirIdx) {
                    Directive dir = clauses.get((int)0).m_dirs.get(dirIdx);
                    if (dir.getName().equalsIgnoreCase("include")) {
                        this.m_activationIncludeDir = (String)dir.getValue();
                        continue;
                    }
                    if (!dir.getName().equalsIgnoreCase("exclude")) continue;
                    this.m_activationExcludeDir = (String)dir.getValue();
                }
                break;
            }
        }
    }

    private static List<ParsedHeaderClause> parseStandardHeader(String header) {
        ArrayList<ParsedHeaderClause> clauses = new ArrayList<ParsedHeaderClause>();
        if (header != null) {
            if (header.length() == 0) {
                throw new IllegalArgumentException("A header cannot be an empty string.");
            }
            List<String> clauseStrings = ManifestParser.parseDelimitedString(header, ",");
            for (int i = 0; clauseStrings != null && i < clauseStrings.size(); ++i) {
                clauses.add(ManifestParser.parseStandardHeaderClause(clauseStrings.get(i)));
            }
        }
        return clauses;
    }

    private static ParsedHeaderClause parseStandardHeaderClause(String clauseString) throws IllegalArgumentException {
        List<String> pieces = ManifestParser.parseDelimitedString(clauseString, ";");
        int pathCount = 0;
        for (int pieceIdx = 0; pieceIdx < pieces.size() && pieces.get(pieceIdx).indexOf(61) < 0; ++pieceIdx) {
            ++pathCount;
        }
        if (pathCount == 0) {
            throw new IllegalArgumentException("No paths specified in header: " + clauseString);
        }
        ArrayList<String> paths = new ArrayList<String>(pathCount);
        for (int pathIdx = 0; pathIdx < pathCount; ++pathIdx) {
            paths.add(pieces.get(pathIdx));
        }
        HashMap<String, Directive> dirsMap = new HashMap<String, Directive>();
        HashMap<String, Attribute> attrsMap = new HashMap<String, Attribute>();
        int idx = -1;
        String sep = null;
        for (int pieceIdx = pathCount; pieceIdx < pieces.size(); ++pieceIdx) {
            idx = pieces.get(pieceIdx).indexOf(":=");
            if (idx >= 0) {
                sep = ":=";
            } else {
                idx = pieces.get(pieceIdx).indexOf("=");
                if (idx >= 0) {
                    sep = "=";
                } else {
                    throw new IllegalArgumentException("Not a directive/attribute: " + clauseString);
                }
            }
            String key = pieces.get(pieceIdx).substring(0, idx).trim();
            String value = pieces.get(pieceIdx).substring(idx + sep.length()).trim();
            if (value.startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            if (sep.equals(":=")) {
                if (dirsMap.get(key) != null) {
                    throw new IllegalArgumentException("Duplicate directive: " + key);
                }
                dirsMap.put(key, new Directive(key, value));
                continue;
            }
            if (attrsMap.get(key) != null) {
                throw new IllegalArgumentException("Duplicate attribute: " + key);
            }
            attrsMap.put(key, new Attribute(key, value, false));
        }
        ArrayList<Directive> dirs = new ArrayList<Directive>(dirsMap.size());
        for (Map.Entry entry : dirsMap.entrySet()) {
            dirs.add((Directive)entry.getValue());
        }
        ArrayList<Attribute> attrs = new ArrayList<Attribute>(attrsMap.size());
        for (Map.Entry entry : attrsMap.entrySet()) {
            attrs.add((Attribute)entry.getValue());
        }
        return new ParsedHeaderClause(paths, dirs, attrs);
    }

    public static List<String> parseDelimitedString(String value, String delim) {
        if (value == null) {
            value = "";
        }
        ArrayList<String> list = new ArrayList<String>();
        int CHAR = 1;
        int DELIMITER = 2;
        int STARTQUOTE = 4;
        int ENDQUOTE = 8;
        StringBuffer sb = new StringBuffer();
        int expecting = CHAR | DELIMITER | STARTQUOTE;
        for (int i = 0; i < value.length(); ++i) {
            boolean isQuote;
            char c = value.charAt(i);
            boolean isDelimiter = delim.indexOf(c) >= 0;
            boolean bl = isQuote = c == '\"';
            if (isDelimiter && (expecting & DELIMITER) > 0) {
                list.add(sb.toString().trim());
                sb.delete(0, sb.length());
                expecting = CHAR | DELIMITER | STARTQUOTE;
                continue;
            }
            if (isQuote && (expecting & STARTQUOTE) > 0) {
                sb.append(c);
                expecting = CHAR | ENDQUOTE;
                continue;
            }
            if (isQuote && (expecting & ENDQUOTE) > 0) {
                sb.append(c);
                expecting = CHAR | STARTQUOTE | DELIMITER;
                continue;
            }
            if ((expecting & CHAR) > 0) {
                sb.append(c);
                continue;
            }
            throw new IllegalArgumentException("Invalid delimited string: " + value);
        }
        if (sb.length() > 0) {
            list.add(sb.toString().trim());
        }
        return list;
    }

    private static List<R4LibraryClause> parseLibraryStrings(Logger logger, List<String> libStrs) throws IllegalArgumentException {
        if (libStrs == null) {
            return new ArrayList<R4LibraryClause>(0);
        }
        ArrayList<R4LibraryClause> libList = new ArrayList<R4LibraryClause>(libStrs.size());
        for (int i = 0; i < libStrs.size(); ++i) {
            R4LibraryClause clause = R4LibraryClause.parse(logger, libStrs.get(i));
            libList.add(clause);
        }
        return libList;
    }
}

