/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Permission;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.framework.capabilityset.Capability;
import org.apache.felix.framework.capabilityset.Requirement;
import org.apache.felix.framework.resolver.Content;
import org.apache.felix.framework.resolver.FragmentRequirement;
import org.apache.felix.framework.resolver.Module;
import org.apache.felix.framework.resolver.Wire;
import org.apache.felix.framework.util.manifestparser.R4Library;
import org.jboss.logging.Logger;
import org.jboss.osgi.spi.NotImplementedException;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public abstract class AbstractModule
implements Module {
    final Logger log = Logger.getLogger(AbstractModule.class);
    private Bundle bundle;
    private Map<String, String> headerMap;
    private List<Capability> capabilities;
    private List<Requirement> requirements;
    private List<Requirement> dynamicreqs;
    private List<Module> fragments;
    private List<Wire> wires;
    private boolean resolved;

    public AbstractModule(Bundle bundle) {
        this.bundle = bundle;
    }

    @Override
    public Map getHeaders() {
        if (this.headerMap == null) {
            this.headerMap = new HashMap<String, String>();
            Dictionary headers = this.bundle.getHeaders();
            Enumeration keys = headers.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = (String)headers.get(key);
                this.headerMap.put(key, value);
            }
        }
        return Collections.unmodifiableMap(this.headerMap);
    }

    @Override
    public boolean isExtension() {
        return false;
    }

    @Override
    public String getSymbolicName() {
        return this.bundle.getSymbolicName();
    }

    @Override
    public Version getVersion() {
        return this.bundle.getVersion();
    }

    @Override
    public boolean isStale() {
        return false;
    }

    @Override
    public boolean isRemovalPending() {
        return false;
    }

    @Override
    public List<Capability> getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = this.createCapabilities();
        }
        return this.capabilities;
    }

    protected abstract List<Capability> createCapabilities();

    @Override
    public List<Requirement> getRequirements() {
        if (this.requirements == null) {
            this.requirements = this.createRequirements();
        }
        return this.requirements;
    }

    protected abstract List<Requirement> createRequirements();

    @Override
    public List<Requirement> getDynamicRequirements() {
        if (this.dynamicreqs == null) {
            this.dynamicreqs = this.createDynamicRequirements();
        }
        return this.requirements;
    }

    protected abstract List<Requirement> createDynamicRequirements();

    @Override
    public List<R4Library> getNativeLibraries() {
        throw new NotImplementedException();
    }

    @Override
    public int getDeclaredActivationPolicy() {
        throw new NotImplementedException();
    }

    @Override
    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    public String getId() {
        return this.bundle.getLocation();
    }

    @Override
    public List<Wire> getWires() {
        return this.wires != null ? Collections.unmodifiableList(this.wires) : null;
    }

    @Override
    public void setWires(List<Wire> wires) {
        this.wires = wires;
    }

    @Override
    public void removeWires() {
        this.wires = null;
    }

    @Override
    public void attachFragments(List<Module> modules) throws Exception {
        this.fragments = modules;
        this.capabilities = null;
        this.requirements = null;
    }

    @Override
    public void removeFragments() {
        this.fragments = null;
        this.capabilities = null;
        this.requirements = null;
    }

    @Override
    public List<Module> getFragments() {
        if (this.fragments == null) {
            return Collections.emptyList();
        }
        return this.fragments;
    }

    @Override
    public boolean isResolved() {
        return this.resolved;
    }

    @Override
    public void setResolved() {
        this.resolved = true;
    }

    @Override
    public ProtectionDomain getSecurityContext() {
        throw new NotImplementedException();
    }

    @Override
    public boolean impliesDirect(Permission permission) {
        return true;
    }

    @Override
    public Content getContent() {
        throw new NotImplementedException();
    }

    @Override
    public Class<?> getClassByDelegation(String name) throws ClassNotFoundException {
        return this.bundle.loadClass(name);
    }

    @Override
    public URL getResourceByDelegation(String name) {
        return this.bundle.getResource(name);
    }

    @Override
    public Enumeration getResourcesByDelegation(String name) {
        try {
            return this.bundle.getResources(name);
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public URL getEntry(String name) {
        return this.bundle.getEntry(name);
    }

    @Override
    public boolean hasInputStream(int index, String urlPath) throws IOException {
        throw new NotImplementedException();
    }

    @Override
    public InputStream getInputStream(int index, String urlPath) throws IOException {
        throw new NotImplementedException();
    }

    public Wire getWireForRequirement(Requirement requirement) {
        Wire result = null;
        if (this.wires != null) {
            for (Wire aux : this.wires) {
                Requirement auxreq = aux.getRequirement();
                if (auxreq instanceof FragmentRequirement) {
                    auxreq = ((FragmentRequirement)auxreq).getRequirement();
                }
                if (!auxreq.equals(requirement)) continue;
                result = aux;
                break;
            }
        }
        return result;
    }

    public String toString() {
        return "Module[" + this.getBundle() + "]";
    }
}

