/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.capabilityset.Attribute;
import org.apache.felix.framework.capabilityset.Capability;
import org.apache.felix.framework.capabilityset.Directive;
import org.apache.felix.framework.capabilityset.Requirement;
import org.apache.felix.framework.resolver.Module;
import org.apache.felix.framework.resolver.ResolveException;
import org.apache.felix.framework.resolver.Wire;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.manifestparser.RequirementImpl;
import org.jboss.osgi.framework.resolver.AbstractModule;
import org.jboss.osgi.framework.resolver.AbstractResolver;
import org.jboss.osgi.framework.resolver.AbstractResolverState;
import org.jboss.osgi.framework.resolver.LoggerDelegate;
import org.osgi.framework.Bundle;

public abstract class AbstractResolverPlugin {
    private Logger logger = this.getLogger();
    private AbstractResolver resolver = this.getAbstractResolver(this.logger);
    private AbstractResolverState resolverState = this.getAbstractResolverState(this.logger);

    protected Logger getLogger() {
        return new LoggerDelegate();
    }

    protected AbstractResolver getAbstractResolver(Logger logger) {
        return new AbstractResolver(logger);
    }

    protected AbstractResolverState getAbstractResolverState(Logger logger) {
        return new AbstractResolverState(logger);
    }

    public void addModule(AbstractModule module) {
        this.resolverState.addModule(module);
    }

    public void removeModule(AbstractModule module) {
        this.resolverState.removeModule(module);
    }

    public AbstractModule findHost(AbstractModule fragModule) {
        return (AbstractModule)this.resolverState.findHost(fragModule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolve(Module rootModule) throws ResolveException {
        if (!rootModule.isResolved()) {
            boolean locked = this.acquireGlobalLock();
            if (!locked) {
                throw new ResolveException("Unable to acquire global lock for resolve.", rootModule, null);
            }
            try {
                Module newRootModule = this.resolverState.findHost(rootModule);
                if (!Util.isFragment(newRootModule)) {
                    boolean repeat;
                    this.resolverState.checkSingleton(newRootModule);
                    do {
                        repeat = false;
                        try {
                            Map<Module, List<Wire>> wireMap = this.resolver.resolve(this.resolverState, newRootModule);
                            this.markResolvedModules(wireMap);
                        }
                        catch (ResolveException ex) {
                            Module fragment = ex.getFragment();
                            if (fragment != null && rootModule != fragment) {
                                this.resolverState.detachFragment(newRootModule, fragment);
                                repeat = true;
                                continue;
                            }
                            throw ex;
                        }
                    } while (repeat);
                }
            }
            finally {
                this.releaseGlobalLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Wire resolve(Module module, String pkgName) throws ResolveException {
        Wire candidateWire = null;
        if (module.isResolved() && this.isAllowedDynamicImport(module, pkgName)) {
            boolean locked = this.acquireGlobalLock();
            if (!locked) {
                throw new ResolveException("Unable to acquire global lock for resolve.", module, null);
            }
            try {
                List<Wire> wires = module.getWires();
                for (int i = 0; wires != null && i < wires.size(); ++i) {
                    if (!wires.get(i).hasPackage(pkgName)) continue;
                    Wire wire = wires.get(i);
                    return wire;
                }
                Map<Module, List<Wire>> wireMap = this.resolver.resolve(this.resolverState, module, pkgName);
                if (wireMap != null && wireMap.containsKey(module)) {
                    List<Wire> dynamicWires = wireMap.remove(module);
                    candidateWire = dynamicWires.get(0);
                    this.markResolvedModules(wireMap);
                    if (candidateWire != null) {
                        wires = new ArrayList<Wire>(wires.size() + 1);
                        wires.addAll(module.getWires());
                        wires.add(candidateWire);
                        module.setWires(wires);
                        this.logger.log(4, "DYNAMIC WIRE: " + wires.get(wires.size() - 1));
                    }
                }
            }
            finally {
                this.releaseGlobalLock();
            }
        }
        return candidateWire;
    }

    public Set<Capability> getCandidates(Module reqModule, Requirement req, boolean obeyMandatory) {
        return this.resolverState.getCandidates(reqModule, req, obeyMandatory);
    }

    public boolean isAllowedDynamicImport(Module module, String pkgName) {
        if (!module.isResolved() || pkgName.length() == 0) {
            return false;
        }
        List<Requirement> dynamics = module.getDynamicRequirements();
        if (dynamics == null || dynamics.size() == 0) {
            return false;
        }
        List<Capability> caps = module.getCapabilities();
        for (int i = 0; caps != null && i < caps.size(); ++i) {
            if (!caps.get(i).getNamespace().equals("package") || !caps.get(i).getAttribute("package").getValue().equals(pkgName)) continue;
            return false;
        }
        List<Wire> wires = module.getWires();
        for (int i = 0; wires != null && i < wires.size(); ++i) {
            if (!wires.get(i).hasPackage(pkgName)) continue;
            return false;
        }
        List<Directive> dirs = Collections.emptyList();
        ArrayList<Attribute> attrs = new ArrayList<Attribute>(1);
        attrs.add(new Attribute("package", pkgName, false));
        RequirementImpl req = new RequirementImpl(module, "package", dirs, attrs);
        Set<Capability> candidates = this.resolverState.getCandidates(module, req, false);
        return candidates.size() != 0;
    }

    private void markResolvedModules(Map<Module, List<Wire>> wireMap) {
        if (wireMap != null) {
            for (Map.Entry<Module, List<Wire>> entry : wireMap.entrySet()) {
                Module module = entry.getKey();
                List<Wire> wires = entry.getValue();
                for (int wireIdx = 0; wireIdx < wires.size(); ++wireIdx) {
                    this.logger.log(4, "WIRE: " + wires.get(wireIdx));
                }
                module.setWires(wires);
                List<Module> fragments = module.getFragments();
                for (int i = 0; fragments != null && i < fragments.size(); ++i) {
                    fragments.get(i).setResolved();
                    this.markBundleResolved(fragments.get(i));
                    this.logger.log(4, "FRAGMENT WIRE: " + fragments.get(i) + " -> hosted by -> " + module);
                }
                module.setResolved();
                this.resolverState.moduleResolved(module);
                this.markBundleResolved(module);
            }
        }
    }

    public abstract boolean acquireGlobalLock();

    public abstract void releaseGlobalLock();

    public abstract AbstractModule createModule(Bundle var1);

    public abstract AbstractModule getModule(Bundle var1);

    public abstract void markBundleResolved(Module var1);
}

