/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.common.internal;

import org.osgi.framework.Bundle;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogListenerBridge
implements LogListener {
    public void logged(LogEntry entry) {
        Bundle bundle = entry.getBundle();
        int level = entry.getLevel();
        Throwable throwable = entry.getException();
        String loggerName = bundle.getSymbolicName();
        Logger log = LoggerFactory.getLogger((String)loggerName);
        String message = entry.getMessage();
        if (level == 4) {
            log.debug(message, throwable);
        } else if (level == 3) {
            String[] splitMessage = message.split("[\\s]");
            if (throwable != null || splitMessage.length != 2 || !splitMessage[0].endsWith("Event")) {
                log.info(message, throwable);
            }
        } else if (level == 2) {
            log.warn(message, throwable);
        } else if (level == 1) {
            log.error(message, throwable);
        }
    }
}

