/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.vfs30;

import java.io.Closeable;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.osgi.vfs.VFSAdaptor;
import org.jboss.osgi.vfs.VirtualFile;
import org.jboss.osgi.vfs30.VirtualFileAdaptor30;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;

public class VFSAdaptor30
implements VFSAdaptor {
    private static Map<Object, VirtualFile> registry = new ConcurrentHashMap<Object, VirtualFile>();
    private static Set<String> suffixes = new HashSet<String>();

    public VirtualFile getRoot(URL url) throws IOException {
        try {
            org.jboss.vfs.VirtualFile vfsFile = VFS.getChild((URL)url);
            VirtualFileAdaptor30 absFile = (VirtualFileAdaptor30)this.adapt(vfsFile);
            return absFile;
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
    }

    public VirtualFile adapt(Object other) {
        if (other == null) {
            return null;
        }
        if (!(other instanceof org.jboss.vfs.VirtualFile)) {
            throw new IllegalArgumentException("Not a org.jboss.vfs.VirtualFile: " + other);
        }
        org.jboss.vfs.VirtualFile vfsFile = (org.jboss.vfs.VirtualFile)other;
        VirtualFile absFile = registry.get(other);
        if (absFile != null) {
            return absFile;
        }
        Closeable mount = null;
        if (this.acceptForMount(vfsFile)) {
            try {
                TempFileProvider tmp = TempFileProvider.create((String)"osgimount-", null);
                mount = VFS.mountZip((org.jboss.vfs.VirtualFile)vfsFile, (org.jboss.vfs.VirtualFile)vfsFile, (TempFileProvider)tmp);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot mount native file: " + other, ex);
            }
        }
        absFile = new VirtualFileAdaptor30(vfsFile, mount);
        registry.put(vfsFile, absFile);
        return absFile;
    }

    private boolean acceptForMount(org.jboss.vfs.VirtualFile vfsFile) {
        boolean accept = false;
        if (vfsFile.isFile()) {
            String rootName = vfsFile.getName();
            for (String suffix : suffixes) {
                if (!rootName.endsWith(suffix)) continue;
                accept = true;
                break;
            }
        }
        return accept;
    }

    public Object adapt(VirtualFile absFile) {
        if (absFile == null) {
            return null;
        }
        VirtualFileAdaptor30 adaptor = (VirtualFileAdaptor30)absFile;
        return adaptor.getDelegate();
    }

    static void unregister(VirtualFileAdaptor30 absFile) {
        registry.remove(absFile.getDelegate());
    }

    static {
        suffixes.add(".jar");
        suffixes.add(".war");
    }
}

