/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.api;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Configuration;
import org.jboss.shrinkwrap.api.ExtensionLoader;
import org.jboss.shrinkwrap.api.ExtensionType;
import org.jboss.shrinkwrap.api.SecurityActions;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.ResourceAdapterArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationBuilder {
    private static final Logger log = Logger.getLogger(ConfigurationBuilder.class.getName());
    private static final String EXTENSION_LOADER_IMPL = "org.jboss.shrinkwrap.impl.base.ServiceExtensionLoader";
    private ExtensionLoader extensionLoader;
    private ExecutorService executorService;
    private Map<Class<?>, ExtensionType> extensionMappings;

    public ExtensionLoader getExtensionLoader() {
        return this.extensionLoader;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public Map<Class<?>, ExtensionType> getExtensionMapping() {
        return this.extensionMappings;
    }

    public ConfigurationBuilder extensionLoader(ExtensionLoader extensionLoader) {
        this.extensionLoader = extensionLoader;
        return this;
    }

    public ConfigurationBuilder executorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public ConfigurationBuilder extensionMappings(Map<Class<?>, ExtensionType> extensionMappings) {
        this.extensionMappings = extensionMappings;
        return this;
    }

    public Configuration build() {
        this.setDefaults();
        return new Configuration(this);
    }

    private void setDefaults() {
        if (this.getExtensionLoader() == null) {
            ExtensionLoader loader = this.createDefaultExtensionLoader();
            if (log.isLoggable(Level.FINER)) {
                log.finer("User has not defined an explicit " + ExtensionLoader.class.getSimpleName() + "; defaulting to " + loader);
            }
            this.extensionLoader(loader);
        }
        if (this.getExtensionMapping() == null) {
            Map<Class<?>, ExtensionType> extensionMapping = this.createDefaultExtensionMapping();
            if (log.isLoggable(Level.FINER)) {
                log.finer("User has not defined an explicit extensionMapping; defaulting to " + extensionMapping);
            }
            this.extensionMappings(extensionMapping);
        }
    }

    ExtensionLoader createDefaultExtensionLoader() {
        return SecurityActions.newInstance(EXTENSION_LOADER_IMPL, new Class[0], new Object[0], ExtensionLoader.class);
    }

    private Map<Class<?>, ExtensionType> createDefaultExtensionMapping() {
        this.extensionMappings = new HashMap();
        this.extensionMappings.put(WebArchive.class, ExtensionType.WAR);
        this.extensionMappings.put(JavaArchive.class, ExtensionType.JAR);
        this.extensionMappings.put(EnterpriseArchive.class, ExtensionType.EAR);
        this.extensionMappings.put(ResourceAdapterArchive.class, ExtensionType.RAR);
        return this.extensionMappings;
    }
}

