/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import java.io.Serializable;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.Container;
import org.jboss.weld.bean.proxy.AbstractBeanInstance;
import org.jboss.weld.context.CreationalContextImpl;
import org.jboss.weld.context.WeldCreationalContext;
import org.jboss.weld.injection.CurrentInjectionPoint;
import org.jboss.weld.injection.SimpleInjectionPoint;
import org.jboss.weld.serialization.spi.ContextualStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextBeanInstance<T>
extends AbstractBeanInstance
implements Serializable {
    private static final long serialVersionUID = -8144230657830556503L;
    private transient Bean<T> bean;
    private final String id;
    private final Class<?> instanceType;
    private static final ThreadLocal<WeldCreationalContext<?>> currentCreationalContext = new ThreadLocal();

    public ContextBeanInstance(Bean<T> bean, String id) {
        this.bean = bean;
        this.id = id;
        this.instanceType = this.computeInstanceType(bean);
        log.trace("Created context instance locator for bean " + bean + " identified as " + id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getInstance() {
        if (this.bean == null) {
            this.bean = (Bean)((ContextualStore)Container.instance().services().get(ContextualStore.class)).getContextual(this.id);
        }
        Context context = Container.instance().deploymentManager().getContext(this.bean.getScope());
        WeldCreationalContext<?> previousCreationalContext = currentCreationalContext.get();
        WeldCreationalContext<T> creationalContext = currentCreationalContext.get() == null ? new CreationalContextImpl<T>(this.bean) : currentCreationalContext.get().getCreationalContext(this.bean);
        currentCreationalContext.set(creationalContext);
        try {
            ((CurrentInjectionPoint)Container.instance().services().get(CurrentInjectionPoint.class)).push(SimpleInjectionPoint.EMPTY_INJECTION_POINT);
            Object object = context.get(this.bean, creationalContext);
            return (T)object;
        }
        finally {
            ((CurrentInjectionPoint)Container.instance().services().get(CurrentInjectionPoint.class)).pop();
            if (previousCreationalContext == null) {
                currentCreationalContext.remove();
            } else {
                currentCreationalContext.set(previousCreationalContext);
            }
        }
    }

    public Class<T> getInstanceType() {
        return this.instanceType;
    }
}

