/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Extension;
import javax.inject.Inject;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.bean.DisposalMethod;
import org.jboss.weld.bean.InterceptorImpl;
import org.jboss.weld.bean.ManagedBean;
import org.jboss.weld.bean.NewBean;
import org.jboss.weld.bean.NewManagedBean;
import org.jboss.weld.bean.NewSessionBean;
import org.jboss.weld.bean.ProducerField;
import org.jboss.weld.bean.ProducerMethod;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bean.builtin.ee.EEResourceProducerField;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.events.ProcessBeanImpl;
import org.jboss.weld.bootstrap.events.ProcessBeanInjectionTarget;
import org.jboss.weld.bootstrap.events.ProcessManagedBeanImpl;
import org.jboss.weld.bootstrap.events.ProcessObserverMethodImpl;
import org.jboss.weld.bootstrap.events.ProcessProducerFieldImpl;
import org.jboss.weld.bootstrap.events.ProcessProducerImpl;
import org.jboss.weld.bootstrap.events.ProcessProducerMethodImpl;
import org.jboss.weld.bootstrap.events.ProcessSessionBeanImpl;
import org.jboss.weld.ejb.EJBApiAbstraction;
import org.jboss.weld.ejb.InternalEjbDescriptor;
import org.jboss.weld.event.ObserverFactory;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldField;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BootstrapMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.persistence.PersistenceApiAbstraction;
import org.jboss.weld.util.reflection.Reflections;
import org.jboss.weld.ws.WSApiAbstraction;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractBeanDeployer<E extends BeanDeployerEnvironment> {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BOOTSTRAP);
    private final BeanManagerImpl manager;
    private final E environment;

    public AbstractBeanDeployer(BeanManagerImpl manager, E environment) {
        this.manager = manager;
        this.environment = environment;
    }

    protected BeanManagerImpl getManager() {
        return this.manager;
    }

    public AbstractBeanDeployer<E> deploy() {
        Set<RIBean<?>> beans = ((BeanDeployerEnvironment)this.getEnvironment()).getBeans();
        for (DecoratorImpl<?> decoratorImpl : ((BeanDeployerEnvironment)this.getEnvironment()).getDecorators()) {
            decoratorImpl.initialize((BeanDeployerEnvironment)this.getEnvironment());
            ProcessBeanImpl.fire(this.getManager(), decoratorImpl);
            this.manager.addDecorator(decoratorImpl);
            log.debug((Enum)BootstrapMessage.FOUND_DECORATOR, new Object[]{decoratorImpl});
        }
        for (InterceptorImpl interceptorImpl : ((BeanDeployerEnvironment)this.getEnvironment()).getInterceptors()) {
            interceptorImpl.initialize((BeanDeployerEnvironment)this.getEnvironment());
            ProcessBeanImpl.fire(this.getManager(), interceptorImpl);
            this.manager.addInterceptor(interceptorImpl);
            log.debug((Enum)BootstrapMessage.FOUND_INTERCEPTOR, new Object[]{interceptorImpl});
        }
        for (RIBean rIBean : beans) {
            rIBean.initialize((BeanDeployerEnvironment)this.getEnvironment());
            if (!(rIBean instanceof NewBean)) {
                if (rIBean instanceof AbstractProducerBean) {
                    ProcessProducerImpl.fire(this.manager, (AbstractProducerBean)rIBean);
                } else if (rIBean instanceof AbstractClassBean) {
                    ProcessBeanInjectionTarget.fire(this.manager, (AbstractClassBean)rIBean);
                }
                if (rIBean instanceof ManagedBean) {
                    ProcessManagedBeanImpl.fire(this.manager, (ManagedBean)rIBean);
                } else if (rIBean instanceof SessionBean) {
                    ProcessSessionBeanImpl.fire(this.manager, (SessionBean)rIBean);
                } else if (rIBean instanceof ProducerField) {
                    ProcessProducerFieldImpl.fire(this.manager, (ProducerField)rIBean);
                } else if (rIBean instanceof ProducerMethod) {
                    ProcessProducerMethodImpl.fire(this.manager, (ProducerMethod)rIBean);
                } else {
                    ProcessBeanImpl.fire(this.getManager(), rIBean);
                }
            }
            this.manager.addBean(rIBean);
            log.debug((Enum)BootstrapMessage.FOUND_BEAN, new Object[]{rIBean});
        }
        for (ObserverMethodImpl observerMethodImpl : ((BeanDeployerEnvironment)this.getEnvironment()).getObservers()) {
            log.debug((Enum)BootstrapMessage.FOUND_OBSERVER_METHOD, new Object[]{observerMethodImpl});
            observerMethodImpl.initialize();
            ProcessObserverMethodImpl.fire(this.manager, observerMethodImpl);
            this.manager.addObserver(observerMethodImpl);
        }
        return this;
    }

    protected <T> void createObserversProducersDisposers(AbstractClassBean<T> bean) {
        this.createProducerMethods((AbstractClassBean)bean, (WeldClass)bean.getWeldAnnotated());
        this.createProducerFields((AbstractClassBean)bean, (WeldClass)bean.getWeldAnnotated());
        if (this.manager.isBeanEnabled(bean)) {
            this.createObserverMethods((RIBean)bean, (WeldClass)bean.getWeldAnnotated());
        }
        this.createDisposalMethods((AbstractClassBean)bean, (WeldClass)bean.getWeldAnnotated());
    }

    protected <X> void createProducerMethods(AbstractClassBean<X> declaringBean, WeldClass<X> annotatedClass) {
        for (WeldMethod<?, X> method : annotatedClass.getDeclaredWeldMethods(Produces.class)) {
            this.createProducerMethod(declaringBean, method);
        }
    }

    protected <X> void createDisposalMethods(AbstractClassBean<X> declaringBean, WeldClass<X> annotatedClass) {
        for (WeldMethod<?, X> method : annotatedClass.getDeclaredWeldMethodsWithAnnotatedParameters(Disposes.class)) {
            DisposalMethod<X, ?> disposalBean = DisposalMethod.of(this.manager, method, declaringBean);
            disposalBean.initialize((BeanDeployerEnvironment)this.getEnvironment());
            ((BeanDeployerEnvironment)this.getEnvironment()).addDisposesMethod(disposalBean);
        }
    }

    protected <X, T> void createProducerMethod(AbstractClassBean<X> declaringBean, WeldMethod<T, ? super X> annotatedMethod) {
        ProducerMethod<? super X, T> bean = ProducerMethod.of(annotatedMethod, declaringBean, this.manager);
        ((BeanDeployerEnvironment)this.getEnvironment()).addProducerMethod(bean);
    }

    protected <X, T> void createProducerField(AbstractClassBean<X> declaringBean, WeldField<T, ? super X> field) {
        ProducerField bean = this.isEEResourceProducerField(field) ? EEResourceProducerField.of(field, declaringBean, this.manager) : ProducerField.of(field, declaringBean, this.manager);
        ((BeanDeployerEnvironment)this.getEnvironment()).addProducerField(bean);
    }

    protected <X> void createProducerFields(AbstractClassBean<X> declaringBean, WeldClass<X> annotatedClass) {
        for (WeldField<?, X> field : annotatedClass.getDeclaredWeldFields(Produces.class)) {
            this.createProducerField(declaringBean, field);
        }
    }

    protected <X> void createObserverMethods(RIBean<X> declaringBean, WeldClass<X> annotatedClass) {
        for (WeldMethod<?, X> method : annotatedClass.getDeclaredWeldMethodsWithAnnotatedParameters(Observes.class)) {
            this.createObserverMethod(declaringBean, method);
        }
    }

    protected <T, X> void createObserverMethod(RIBean<X> declaringBean, WeldMethod<T, ? super X> method) {
        ObserverMethodImpl<T, ? super X> observer = ObserverFactory.create(method, declaringBean, this.manager);
        ((BeanDeployerEnvironment)this.getEnvironment()).addObserverMethod(observer);
    }

    protected <T> ManagedBean<T> createManagedBean(WeldClass<T> annotatedClass) {
        ManagedBean<T> bean = ManagedBean.of(annotatedClass, this.manager);
        ((BeanDeployerEnvironment)this.getEnvironment()).addManagedBean(bean);
        this.createObserversProducersDisposers(bean);
        return bean;
    }

    protected <T> void createNewManagedBean(WeldClass<T> annotatedClass) {
        ((BeanDeployerEnvironment)this.getEnvironment()).addManagedBean(NewManagedBean.of(annotatedClass, this.manager));
    }

    protected <T> void createDecorator(WeldClass<T> annotatedClass) {
        DecoratorImpl<T> bean = DecoratorImpl.of(annotatedClass, this.manager);
        ((BeanDeployerEnvironment)this.getEnvironment()).addDecorator(bean);
    }

    protected <T> void createInterceptor(WeldClass<T> annotatedClass) {
        InterceptorImpl<T> bean = InterceptorImpl.of(annotatedClass, this.manager);
        ((BeanDeployerEnvironment)this.getEnvironment()).addInterceptor(bean);
    }

    protected <T> SessionBean<T> createSessionBean(InternalEjbDescriptor<T> ejbDescriptor) {
        SessionBean<T> bean = SessionBean.of(ejbDescriptor, this.manager);
        ((BeanDeployerEnvironment)this.getEnvironment()).addSessionBean(bean);
        this.createObserversProducersDisposers(bean);
        return bean;
    }

    protected <T> SessionBean<T> createSessionBean(InternalEjbDescriptor<T> ejbDescriptor, WeldClass<T> weldClass) {
        SessionBean<T> bean = SessionBean.of(ejbDescriptor, this.manager, weldClass);
        ((BeanDeployerEnvironment)this.getEnvironment()).addSessionBean(bean);
        this.createObserversProducersDisposers(bean);
        return bean;
    }

    protected <T> void createNewSessionBean(InternalEjbDescriptor<T> ejbDescriptor) {
        ((BeanDeployerEnvironment)this.getEnvironment()).addSessionBean(NewSessionBean.of(ejbDescriptor, this.manager));
    }

    protected boolean isTypeManagedBeanOrDecoratorOrInterceptor(WeldClass<?> clazz) {
        Class javaClass = clazz.getJavaClass();
        return !Extension.class.isAssignableFrom(clazz.getJavaClass()) && !clazz.isAnonymousClass() && (!clazz.isMemberClass() || clazz.isStatic()) && !Reflections.isParamerterizedTypeWithWildcard(javaClass) && AbstractBeanDeployer.hasSimpleWebBeanConstructor(clazz);
    }

    protected boolean isEEResourceProducerField(WeldField<?, ?> field) {
        EJBApiAbstraction ejbApiAbstraction = (EJBApiAbstraction)this.manager.getServices().get(EJBApiAbstraction.class);
        PersistenceApiAbstraction persistenceApiAbstraction = (PersistenceApiAbstraction)this.manager.getServices().get(PersistenceApiAbstraction.class);
        WSApiAbstraction wsApiAbstraction = (WSApiAbstraction)this.manager.getServices().get(WSApiAbstraction.class);
        return field.isAnnotationPresent(ejbApiAbstraction.EJB_ANNOTATION_CLASS) || field.isAnnotationPresent(ejbApiAbstraction.RESOURCE_ANNOTATION_CLASS) || field.isAnnotationPresent(persistenceApiAbstraction.PERSISTENCE_UNIT_ANNOTATION_CLASS) || field.isAnnotationPresent(persistenceApiAbstraction.PERSISTENCE_CONTEXT_ANNOTATION_CLASS) || field.isAnnotationPresent(wsApiAbstraction.WEB_SERVICE_REF_ANNOTATION_CLASS);
    }

    private static boolean hasSimpleWebBeanConstructor(WeldClass<?> type) {
        return type.getNoArgsWeldConstructor() != null || type.getWeldConstructors(Inject.class).size() > 0;
    }

    public E getEnvironment() {
        return this.environment;
    }
}

