/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resources;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.util.collections.EnumerationList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResourceLoader
implements ResourceLoader {
    public Class<?> classForName(String name) {
        try {
            if (Thread.currentThread().getContextClassLoader() != null) {
                return Thread.currentThread().getContextClassLoader().loadClass(name);
            }
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new ResourceLoadingException("Error loading class " + name, (Throwable)e);
        }
        catch (NoClassDefFoundError e) {
            throw new ResourceLoadingException("Error loading class " + name, (Throwable)e);
        }
        catch (TypeNotPresentException e) {
            throw new ResourceLoadingException("Error loading class " + name, (Throwable)e);
        }
    }

    public URL getResource(String name) {
        if (Thread.currentThread().getContextClassLoader() != null) {
            return Thread.currentThread().getContextClassLoader().getResource(name);
        }
        return this.getClass().getResource(name);
    }

    public Collection<URL> getResources(String name) {
        try {
            if (Thread.currentThread().getContextClassLoader() != null) {
                return new EnumerationList<URL>(Thread.currentThread().getContextClassLoader().getResources(name));
            }
            return new EnumerationList<URL>(this.getClass().getClassLoader().getResources(name));
        }
        catch (IOException e) {
            throw new ResourceLoadingException("Error loading resource " + name, (Throwable)e);
        }
    }

    public void cleanup() {
    }
}

