/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer;

import java.util.Collection;
import java.util.List;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.deployers.structure.spi.DeploymentUnit;

public final class DeployersUtils {
    public static final String JAVAX_VALIDATION_VALIDATOR_FACTORY = "javax.validation.ValidatorFactory";
    public static final String WELD_FILES = "WELD_FILES";
    public static final String WELD_CLASSPATH = "WELD_CLASSPATH";
    public static final String WELD_DEPLOYMENT_FLAG = "WELD_DEPLOYMENT_FLAG";
    public static final String WELD_BOOTSTRAP_BEAN = "_WeldBootstrapBean";

    private DeployersUtils() {
    }

    public static String getBootstrapBeanName(DeploymentUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Null deployment unit");
        }
        DeploymentUnit top = unit.getTopLevel();
        return top.getName() + WELD_BOOTSTRAP_BEAN;
    }

    public static String getBootstrapBeanAttachmentName(DeploymentUnit unit) {
        return DeployersUtils.getBootstrapBeanName(unit) + "_" + BeanMetaData.class.getSimpleName();
    }

    public static boolean isBootstrapBeanPresent(DeploymentUnit unit) {
        String attachmentName = DeployersUtils.getBootstrapBeanAttachmentName(unit);
        DeploymentUnit top = unit.getTopLevel();
        return top.isAttachmentPresent(attachmentName);
    }

    public static String getDeploymentBeanName(DeploymentUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Null deployment unit");
        }
        return unit.getName() + "_JBossDeployment";
    }

    public static String getDeploymentAttachmentName(DeploymentUnit unit) {
        return DeployersUtils.getDeploymentBeanName(unit);
    }

    public static boolean checkForWeldFilesInUnitAndChildren(DeploymentUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Null deployment unit");
        }
        DeploymentUnit top = unit.getTopLevel();
        Boolean flag = (Boolean)top.getAttachment(WELD_DEPLOYMENT_FLAG, Boolean.class);
        if (flag != null) {
            return flag;
        }
        flag = DeployersUtils.searchForBeans(top);
        top.addAttachment(WELD_DEPLOYMENT_FLAG, (Object)flag, Boolean.class);
        return flag;
    }

    private static boolean searchForBeans(DeploymentUnit unit) {
        Collection files = (Collection)unit.getAttachment(WELD_FILES, Collection.class);
        if (files != null && !files.isEmpty()) {
            return true;
        }
        List children = unit.getChildren();
        if (children != null && !children.isEmpty()) {
            for (DeploymentUnit child : children) {
                boolean result = DeployersUtils.searchForBeans(child);
                if (!result) continue;
                return true;
            }
        }
        return false;
    }
}

