/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.interceptor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.Interceptor;
import org.jboss.interceptor.spi.metadata.ClassMetadata;
import org.jboss.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.interceptor.spi.model.InterceptionModel;
import org.jboss.interceptor.spi.model.InterceptionType;
import org.jboss.weld.ejb.spi.InterceptorBindings;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.serialization.spi.helpers.SerializableContextual;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorBindingsAdapter
implements InterceptorBindings {
    private InterceptionModel<ClassMetadata<?>, ?> interceptionModel;

    public InterceptorBindingsAdapter(InterceptionModel<ClassMetadata<?>, ?> interceptionModel) {
        if (interceptionModel == null) {
            throw new IllegalArgumentException(BeanMessage.INTERCEPTION_MODEL_NULL, new Object[0]);
        }
        this.interceptionModel = interceptionModel;
    }

    public Collection<Interceptor<?>> getAllInterceptors() {
        Set interceptorMetadataSet = this.interceptionModel.getAllInterceptors();
        return this.extractSerializableContextualInterceptors(interceptorMetadataSet);
    }

    public List<Interceptor<?>> getMethodInterceptors(javax.enterprise.inject.spi.InterceptionType interceptionType, Method method) {
        if (interceptionType == null) {
            throw new IllegalArgumentException(BeanMessage.INTERCEPTION_TYPE_NULL, new Object[0]);
        }
        if (method == null) {
            throw new IllegalArgumentException(BeanMessage.METHOD_NULL, new Object[0]);
        }
        InterceptionType internalInterceptionType = InterceptionType.valueOf((String)interceptionType.name());
        if (internalInterceptionType.isLifecycleCallback()) {
            throw new IllegalArgumentException(BeanMessage.INTERCEPTION_TYPE_LIFECYCLE, interceptionType.name());
        }
        return this.extractSerializableContextualInterceptors(this.interceptionModel.getInterceptors(internalInterceptionType, method));
    }

    public List<Interceptor<?>> getLifecycleInterceptors(javax.enterprise.inject.spi.InterceptionType interceptionType) {
        if (interceptionType == null) {
            throw new IllegalArgumentException(BeanMessage.INTERCEPTION_TYPE_NULL, new Object[0]);
        }
        InterceptionType internalInterceptionType = InterceptionType.valueOf((String)interceptionType.name());
        if (!internalInterceptionType.isLifecycleCallback()) {
            throw new IllegalArgumentException(BeanMessage.INTERCEPTION_TYPE_NOT_LIFECYCLE, interceptionType.name());
        }
        return this.extractSerializableContextualInterceptors(this.interceptionModel.getInterceptors(internalInterceptionType, null));
    }

    private List<Interceptor<?>> extractSerializableContextualInterceptors(Collection<? extends InterceptorMetadata<?>> interceptorMetadatas) {
        ArrayList interceptors = new ArrayList();
        for (InterceptorMetadata<?> interceptorMetadata : interceptorMetadatas) {
            Object interceptor = interceptorMetadata.getInterceptorReference().getInterceptor();
            if (!(interceptor instanceof SerializableContextual)) continue;
            interceptors.add((Interceptor<?>)((SerializableContextual)interceptor).get());
        }
        return interceptors;
    }
}

