/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.serialization.spi.ProxyServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleProxyServices
implements ProxyServices {
    public ClassLoader getClassLoader(final Class<?> proxiedBeanType) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return SimpleProxyServices.this._getClassLoader(proxiedBeanType);
                }
            });
        }
        return this._getClassLoader(proxiedBeanType);
    }

    private ClassLoader _getClassLoader(Class<?> proxiedBeanType) {
        if (proxiedBeanType.getName().startsWith("java")) {
            return this.getClass().getClassLoader();
        }
        return proxiedBeanType.getClassLoader();
    }

    public void cleanup() {
    }

    public Class<?> loadBeanClass(final String className) {
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return Class.forName(className, true, SimpleProxyServices.this.getClassLoader(this.getClass()));
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new WeldException(BeanMessage.CANNOT_LOAD_CLASS, className, pae.getException());
        }
    }
}

