/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.enterprise.context.ConversationScoped;
import org.jboss.weld.context.AbstractBoundContext;
import org.jboss.weld.context.ConversationContext;
import org.jboss.weld.context.ManagedConversation;
import org.jboss.weld.context.beanstore.BoundBeanStore;
import org.jboss.weld.context.beanstore.ConversationNamingScheme;
import org.jboss.weld.context.beanstore.NamingScheme;
import org.jboss.weld.context.conversation.ConversationIdGenerator;
import org.jboss.weld.context.conversation.ConversationImpl;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConversationContext<R, S>
extends AbstractBoundContext<R>
implements ConversationContext {
    private static final String IDENTIFIER = AbstractConversationContext.class.getName();
    private static final String CURRENT_CONVERSATION_ATTRIBUTE_NAME = ConversationContext.class.getName() + ".currentConversation";
    public static final String CONVERSATIONS_ATTRIBUTE_NAME = ConversationContext.class.getName() + ".conversations";
    private static final long DEFAULT_TIMEOUT = 600000L;
    private static final long CONCURRENT_ACCESS_TIMEOUT = 1000L;
    private static final String PARAMETER_NAME = "cid";
    private final AtomicReference<String> parameterName = new AtomicReference<String>("cid");
    private final AtomicLong defaultTimeout = new AtomicLong(600000L);
    private final AtomicLong concurrentAccessTimeout = new AtomicLong(1000L);
    private final ThreadLocal<R> associated = new ThreadLocal();

    public AbstractConversationContext() {
        super(true);
    }

    public String getParameterName() {
        return this.parameterName.get();
    }

    public void setParameterName(String cid) {
        this.parameterName.set(cid);
    }

    public void setConcurrentAccessTimeout(long timeout) {
        this.concurrentAccessTimeout.set(timeout);
    }

    public long getConcurrentAccessTimeout() {
        return this.concurrentAccessTimeout.get();
    }

    public void setDefaultTimeout(long timeout) {
        this.defaultTimeout.set(timeout);
    }

    public long getDefaultTimeout() {
        return this.defaultTimeout.get();
    }

    public boolean associate(R request) {
        if (this.getRequestAttribute(request, IDENTIFIER) == null) {
            this.associated.set(request);
            this.setRequestAttribute(request, IDENTIFIER, IDENTIFIER);
            if (this.getSessionAttribute(request, ConversationIdGenerator.CONVERSATION_ID_GENERATOR_ATTRIBUTE_NAME, false) == null) {
                ConversationIdGenerator generator = new ConversationIdGenerator();
                this.setRequestAttribute(request, ConversationIdGenerator.CONVERSATION_ID_GENERATOR_ATTRIBUTE_NAME, generator);
                this.setSessionAttribute(request, ConversationIdGenerator.CONVERSATION_ID_GENERATOR_ATTRIBUTE_NAME, generator, false);
            } else {
                this.setRequestAttribute(request, ConversationIdGenerator.CONVERSATION_ID_GENERATOR_ATTRIBUTE_NAME, this.getSessionAttribute(request, ConversationIdGenerator.CONVERSATION_ID_GENERATOR_ATTRIBUTE_NAME, true));
            }
            if (this.getSessionAttribute(request, CONVERSATIONS_ATTRIBUTE_NAME, false) == null) {
                HashMap conversations = new HashMap();
                this.setRequestAttribute(request, CONVERSATIONS_ATTRIBUTE_NAME, conversations);
                this.setSessionAttribute(request, CONVERSATIONS_ATTRIBUTE_NAME, conversations, false);
            } else {
                this.setRequestAttribute(request, CONVERSATIONS_ATTRIBUTE_NAME, this.getSessionAttribute(request, CONVERSATIONS_ATTRIBUTE_NAME, true));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dissociate(R request) {
        if (this.isAssociated() && this.getRequestAttribute(request, IDENTIFIER) != null) {
            try {
                if (this.getSessionAttribute(request, ConversationIdGenerator.CONVERSATION_ID_GENERATOR_ATTRIBUTE_NAME, false) == null) {
                    this.setSessionAttribute(request, ConversationIdGenerator.CONVERSATION_ID_GENERATOR_ATTRIBUTE_NAME, this.getRequestAttribute(request, ConversationIdGenerator.CONVERSATION_ID_GENERATOR_ATTRIBUTE_NAME), false);
                }
                if (this.getSessionAttribute(request, CONVERSATIONS_ATTRIBUTE_NAME, false) == null) {
                    this.setSessionAttribute(request, CONVERSATIONS_ATTRIBUTE_NAME, this.getRequestAttribute(request, CONVERSATIONS_ATTRIBUTE_NAME), false);
                }
                this.associated.set(null);
                this.removeRequestAttribute(request, IDENTIFIER);
                boolean bl = true;
                return bl;
            }
            finally {
                this.cleanup();
            }
        }
        return false;
    }

    @Override
    public void activate() {
        this.activate(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deactivate() {
        if (this.getBeanStore() != null) {
            if (!this.isAssociated()) {
                throw new IllegalStateException("Must call associate() before calling deactivate()");
            }
            if (this.getCurrentConversation().isTransient()) {
                this.destroy();
            } else {
                try {
                    this.getCurrentConversation().touch();
                    if (!this.getBeanStore().isAttached()) {
                        if (!(this.getRequestAttribute(this.getRequest(), ConversationNamingScheme.PARAMETER_NAME) instanceof ConversationNamingScheme)) {
                            throw new IllegalStateException("Unable to find ConversationNamingScheme in the request, this conversation wasn't transient at the start of the request");
                        }
                        ((ConversationNamingScheme)this.getRequestAttribute(this.getRequest(), ConversationNamingScheme.PARAMETER_NAME)).setCid(this.getCurrentConversation().getId());
                        this.getBeanStore().attach();
                        this.getConversationMap().put(this.getCurrentConversation().getId(), this.getCurrentConversation());
                    }
                }
                finally {
                    this.getCurrentConversation().unlock();
                }
            }
            this.setBeanStore(null);
            for (Map.Entry<String, ManagedConversation> entry : this.getConversationMap().entrySet()) {
                if (!entry.getValue().isTransient()) continue;
                this.destroyConversation(this.getSessionFromRequest(this.getRequest(), false), entry.getKey());
            }
        } else {
            throw new IllegalStateException("Context is not active");
        }
        super.setActive(false);
    }

    public void activate(String cid) {
        if (this.getBeanStore() == null) {
            if (!this.isAssociated()) {
                throw new IllegalStateException("Must call associate() before calling activate()");
            }
            super.setActive(true);
            if (cid == null || this.getConversation(cid) == null) {
                ConversationImpl conversation = new ConversationImpl();
                this.setRequestAttribute(this.getRequest(), CURRENT_CONVERSATION_ATTRIBUTE_NAME, conversation);
                ConversationNamingScheme namingScheme = new ConversationNamingScheme(ConversationContext.class.getName(), "transient");
                this.setBeanStore(this.createRequestBeanStore(namingScheme, this.getRequest()));
                this.setRequestAttribute(this.getRequest(), ConversationNamingScheme.PARAMETER_NAME, namingScheme);
            } else {
                this.setRequestAttribute(this.getRequest(), CURRENT_CONVERSATION_ATTRIBUTE_NAME, this.getConversation(cid));
                this.getCurrentConversation().lock(this.getConcurrentAccessTimeout());
                ConversationNamingScheme namingScheme = new ConversationNamingScheme(ConversationContext.class.getName(), cid);
                this.setBeanStore(this.createRequestBeanStore(namingScheme, this.getRequest()));
                this.getBeanStore().attach();
            }
        } else {
            throw new IllegalStateException("Context is already active");
        }
    }

    @Override
    public void invalidate() {
        for (ManagedConversation conversation : this.getConversations()) {
            if (!AbstractConversationContext.isExpired(conversation) || conversation.isTransient()) continue;
            conversation.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destroy(S session) {
        try {
            if (this.getSessionAttributeFromSession(session, CONVERSATIONS_ATTRIBUTE_NAME) instanceof Map) {
                Map conversations = (Map)Reflections.cast(this.getSessionAttributeFromSession(session, CONVERSATIONS_ATTRIBUTE_NAME));
                this.setActive(true);
                for (ManagedConversation conversation : conversations.values()) {
                    String id = conversation.getId();
                    conversation.end();
                    this.destroyConversation(session, id);
                }
                this.setActive(false);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.cleanup();
        }
    }

    protected void destroyConversation(S session, String id) {
        if (session != null) {
            this.setBeanStore(this.createSessionBeanStore(new ConversationNamingScheme(ConversationContext.class.getName(), id), session));
            this.getBeanStore().attach();
            this.destroy();
            this.getBeanStore().detach();
            this.setBeanStore(null);
        }
    }

    public String generateConversationId() {
        if (!this.isAssociated()) {
            throw new IllegalStateException("A request must be associated with the context in order to generate a conversation id");
        }
        if (!(this.getRequestAttribute(this.getRequest(), ConversationIdGenerator.CONVERSATION_ID_GENERATOR_ATTRIBUTE_NAME) instanceof ConversationIdGenerator)) {
            throw new IllegalStateException("Unable to locate ConversationIdGenerator");
        }
        ConversationIdGenerator generator = (ConversationIdGenerator)this.getRequestAttribute(this.getRequest(), ConversationIdGenerator.CONVERSATION_ID_GENERATOR_ATTRIBUTE_NAME);
        return generator.call();
    }

    private static boolean isExpired(ManagedConversation conversation) {
        return System.currentTimeMillis() > conversation.getLastUsed() + conversation.getTimeout();
    }

    public ManagedConversation getConversation(String id) {
        return this.getConversationMap().get(id);
    }

    public Collection<ManagedConversation> getConversations() {
        return this.getConversationMap().values();
    }

    private Map<String, ManagedConversation> getConversationMap() {
        if (!this.isAssociated()) {
            throw new IllegalStateException("A request must be associated with the context in order to load the known conversations");
        }
        if (!(this.getRequestAttribute(this.getRequest(), CONVERSATIONS_ATTRIBUTE_NAME) instanceof Map)) {
            throw new IllegalStateException("Unable to load current conversations from the associated request, something went badly wrong when associate() was called");
        }
        return (Map)Reflections.cast(this.getRequestAttribute(this.getRequest(), CONVERSATIONS_ATTRIBUTE_NAME));
    }

    public ManagedConversation getCurrentConversation() {
        if (!this.isAssociated()) {
            throw new IllegalStateException("A request must be associated with the context in order to load the known conversations");
        }
        if (!(this.getRequestAttribute(this.getRequest(), CURRENT_CONVERSATION_ATTRIBUTE_NAME) instanceof ManagedConversation)) {
            throw new IllegalStateException("Unable to load current conversations from the associated request, something went badly wrong when associate() was called");
        }
        return (ManagedConversation)this.getRequestAttribute(this.getRequest(), CURRENT_CONVERSATION_ATTRIBUTE_NAME);
    }

    public Class<? extends Annotation> getScope() {
        return ConversationScoped.class;
    }

    protected abstract void setSessionAttribute(R var1, String var2, Object var3, boolean var4);

    protected abstract Object getSessionAttribute(R var1, String var2, boolean var3);

    protected abstract Object getSessionAttributeFromSession(S var1, String var2);

    protected abstract void removeRequestAttribute(R var1, String var2);

    protected abstract void setRequestAttribute(R var1, String var2, Object var3);

    protected abstract Object getRequestAttribute(R var1, String var2);

    protected abstract BoundBeanStore createRequestBeanStore(NamingScheme var1, R var2);

    protected abstract BoundBeanStore createSessionBeanStore(NamingScheme var1, S var2);

    protected abstract S getSessionFromRequest(R var1, boolean var2);

    private boolean isAssociated() {
        return this.associated.get() != null;
    }

    private R getRequest() {
        return this.associated.get();
    }
}

