/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.introspector.jlr;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import org.jboss.weld.introspector.ConstructorSignature;
import org.jboss.weld.introspector.ExternalAnnotatedType;
import org.jboss.weld.introspector.MethodSignature;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldConstructor;
import org.jboss.weld.introspector.WeldField;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.introspector.jlr.AbstractWeldAnnotated;
import org.jboss.weld.introspector.jlr.WeldConstructorImpl;
import org.jboss.weld.introspector.jlr.WeldFieldImpl;
import org.jboss.weld.introspector.jlr.WeldMethodImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.collections.ArraySet;
import org.jboss.weld.util.collections.ArraySetMultimap;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.HierarchyDiscovery;
import org.jboss.weld.util.reflection.Reflections;
import org.jboss.weld.util.reflection.SecureReflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeldClassImpl<T>
extends AbstractWeldAnnotated<T, Class<T>>
implements WeldClass<T> {
    private final WeldClass<? super T> superclass;
    private final Set<WeldField<?, ?>> fields;
    private final ArrayListMultimap<Class<? extends Annotation>, WeldField<?, ?>> annotatedFields;
    private final ArraySet<WeldField<?, ?>> declaredFields;
    private final Map<String, WeldField<?, ?>> declaredFieldsByName;
    private final ArrayListMultimap<Class<? extends Annotation>, WeldField<?, ? super T>> declaredAnnotatedFields;
    private final ArrayListMultimap<Class<? extends Annotation>, WeldField<?, ?>> declaredMetaAnnotatedFields;
    private final Set<WeldMethod<?, ? super T>> methods;
    private final Map<MethodSignature, WeldMethod<?, ?>> declaredMethodsBySignature;
    private final Map<MethodSignature, WeldMethod<?, ?>> methodsBySignature;
    private final ArrayListMultimap<Class<? extends Annotation>, WeldMethod<?, ?>> annotatedMethods;
    private final ArraySet<WeldMethod<?, ? super T>> declaredMethods;
    private final ArrayListMultimap<Class<? extends Annotation>, WeldMethod<?, ? super T>> declaredAnnotatedMethods;
    private final ArrayListMultimap<Class<? extends Annotation>, WeldMethod<?, ? super T>> declaredMethodsByAnnotatedParameters;
    private final ArrayList<AnnotatedConstructor<T>> constructors;
    private final Map<ConstructorSignature, WeldConstructor<?>> declaredConstructorsBySignature;
    private final ArrayListMultimap<Class<? extends Annotation>, WeldConstructor<T>> annotatedConstructors;
    private final Map<List<Class<?>>, WeldConstructor<T>> constructorsByArgumentMap;
    private final ArraySetMultimap<Class<? extends Annotation>, Annotation> declaredMetaAnnotationMap;
    private final boolean discovered;

    private static <T> void mapConstructorAnnotations(ArrayListMultimap<Class<? extends Annotation>, WeldConstructor<T>> annotatedConstructors, WeldConstructor<T> annotatedConstructor) {
        for (Annotation annotation : annotatedConstructor.getAnnotations()) {
            if (!annotatedConstructors.containsKey(annotation.annotationType())) {
                annotatedConstructors.putAll(annotation.annotationType(), new HashSet());
            }
            annotatedConstructors.get(annotation.annotationType()).add(annotatedConstructor);
        }
    }

    public static <T> WeldClass<T> of(Class<T> clazz, ClassTransformer classTransformer) {
        return new WeldClassImpl<T>(clazz, clazz, null, new HierarchyDiscovery(clazz).getTypeClosure(), WeldClassImpl.buildAnnotationMap(clazz.getAnnotations()), WeldClassImpl.buildAnnotationMap(clazz.getDeclaredAnnotations()), classTransformer);
    }

    public static <T> WeldClass<T> of(AnnotatedType<T> annotatedType, ClassTransformer classTransformer) {
        return new WeldClassImpl<T>(annotatedType.getJavaClass(), annotatedType.getBaseType(), annotatedType, annotatedType.getTypeClosure(), WeldClassImpl.buildAnnotationMap(annotatedType.getAnnotations()), WeldClassImpl.buildAnnotationMap(annotatedType.getAnnotations()), classTransformer);
    }

    public static <T> WeldClass<T> of(Class<T> rawType, Type type, ClassTransformer classTransformer) {
        return new WeldClassImpl<T>(rawType, type, null, new HierarchyDiscovery(type).getTypeClosure(), WeldClassImpl.buildAnnotationMap(rawType.getAnnotations()), WeldClassImpl.buildAnnotationMap(rawType.getDeclaredAnnotations()), classTransformer);
    }

    protected WeldClassImpl(Class<T> rawType, Type type, AnnotatedType<T> annotatedType, Set<Type> typeClosure, Map<Class<? extends Annotation>, Annotation> annotationMap, Map<Class<? extends Annotation>, Annotation> declaredAnnotationMap, ClassTransformer classTransformer) {
        super(annotationMap, declaredAnnotationMap, classTransformer, rawType, type, typeClosure);
        this.discovered = !(annotatedType instanceof ExternalAnnotatedType);
        this.superclass = rawType.getSuperclass() != null ? classTransformer.loadClass(rawType.getSuperclass()) : null;
        this.declaredFieldsByName = new HashMap();
        this.declaredAnnotatedFields = ArrayListMultimap.create();
        this.declaredMetaAnnotatedFields = ArrayListMultimap.create();
        Set<WeldField<Object, Object>> fieldsTemp = null;
        ArrayList declaredFieldsTemp = new ArrayList();
        if (annotatedType == null) {
            this.annotatedFields = null;
            if (rawType != Object.class) {
                for (Field field : SecureReflections.getDeclaredFields(rawType)) {
                    WeldFieldImpl annotatedField = WeldFieldImpl.of(field, this.getDeclaringWeldClass(field, classTransformer), classTransformer);
                    declaredFieldsTemp.add(annotatedField);
                    this.declaredFieldsByName.put(annotatedField.getName(), annotatedField);
                    for (Annotation annotation : annotatedField.getAnnotations()) {
                        this.declaredAnnotatedFields.put(annotation.annotationType(), annotatedField);
                        for (Annotation metaAnnotation : annotation.annotationType().getAnnotations()) {
                            this.declaredMetaAnnotatedFields.put(metaAnnotation.annotationType(), annotatedField);
                        }
                    }
                }
                fieldsTemp = new ArraySet(declaredFieldsTemp).trimToSize();
                if (this.superclass != null && this.superclass.getJavaClass() != Object.class) {
                    fieldsTemp = Sets.union(fieldsTemp, (Set)this.superclass.getFields());
                }
            }
            this.declaredFields = new ArraySet(declaredFieldsTemp);
        } else {
            this.annotatedFields = ArrayListMultimap.create();
            fieldsTemp = new HashSet();
            for (AnnotatedField annotatedField : annotatedType.getFields()) {
                WeldFieldImpl weldField = WeldFieldImpl.of(annotatedField, this, classTransformer);
                fieldsTemp.add(weldField);
                if (annotatedField.getDeclaringType().getJavaClass() == rawType) {
                    declaredFieldsTemp.add(weldField);
                    this.declaredFieldsByName.put(weldField.getName(), weldField);
                }
                for (Annotation annotation : weldField.getAnnotations()) {
                    this.annotatedFields.put(annotation.annotationType(), weldField);
                    if (annotatedField.getDeclaringType().getJavaClass() != rawType) continue;
                    this.declaredAnnotatedFields.put(annotation.annotationType(), weldField);
                    for (Annotation metaAnnotation : annotation.annotationType().getAnnotations()) {
                        this.declaredMetaAnnotatedFields.put(metaAnnotation.annotationType(), weldField);
                    }
                }
            }
            this.declaredFields = new ArraySet(declaredFieldsTemp);
            fieldsTemp = new ArraySet(fieldsTemp).trimToSize();
            this.annotatedFields.trimToSize();
        }
        this.fields = fieldsTemp;
        this.declaredFields.trimToSize();
        this.declaredAnnotatedFields.trimToSize();
        this.declaredMetaAnnotatedFields.trimToSize();
        this.constructors = new ArrayList();
        this.constructorsByArgumentMap = new HashMap();
        this.annotatedConstructors = ArrayListMultimap.create();
        this.declaredConstructorsBySignature = new HashMap();
        if (annotatedType == null) {
            AccessibleObject[] arr$ = SecureReflections.getDeclaredConstructors(rawType);
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                AccessibleObject constructor;
                AccessibleObject c = constructor = arr$[i$];
                WeldConstructor annotatedConstructor = WeldConstructorImpl.of(c, this.getDeclaringWeldClass((Member)((Object)c), classTransformer), classTransformer);
                this.constructors.add(annotatedConstructor);
                this.constructorsByArgumentMap.put(Arrays.asList(((Constructor)constructor).getParameterTypes()), annotatedConstructor);
                this.declaredConstructorsBySignature.put(annotatedConstructor.getSignature(), annotatedConstructor);
                WeldClassImpl.mapConstructorAnnotations(this.annotatedConstructors, annotatedConstructor);
            }
        } else {
            for (AnnotatedConstructor constructor : annotatedType.getConstructors()) {
                WeldConstructor weldConstructor = WeldConstructorImpl.of(constructor, this, classTransformer);
                this.constructors.add(weldConstructor);
                ArrayList parameterTypes = new ArrayList();
                for (AnnotatedParameter parameter : constructor.getParameters()) {
                    parameterTypes.add(Reflections.getRawType(parameter.getBaseType()));
                }
                this.constructorsByArgumentMap.put(parameterTypes, weldConstructor);
                this.declaredConstructorsBySignature.put(weldConstructor.getSignature(), weldConstructor);
                WeldClassImpl.mapConstructorAnnotations(this.annotatedConstructors, weldConstructor);
            }
        }
        this.constructors.trimToSize();
        this.annotatedConstructors.trimToSize();
        this.declaredAnnotatedMethods = ArrayListMultimap.create();
        this.declaredMethodsByAnnotatedParameters = ArrayListMultimap.create();
        this.declaredMethodsBySignature = new HashMap();
        Set<WeldMethod<Object, Object>> methodsTemp = null;
        ArrayList declaredMethodsTemp = new ArrayList();
        if (annotatedType == null) {
            this.annotatedMethods = null;
            this.methodsBySignature = null;
            if (rawType != Object.class) {
                for (Method method : SecureReflections.getDeclaredMethods(rawType)) {
                    WeldMethodImpl weldMethod = WeldMethodImpl.of(method, this.getDeclaringWeldClass(method, classTransformer), classTransformer);
                    declaredMethodsTemp.add(weldMethod);
                    this.declaredMethodsBySignature.put(weldMethod.getSignature(), weldMethod);
                    for (Annotation annotation : weldMethod.getAnnotations()) {
                        this.declaredAnnotatedMethods.put(annotation.annotationType(), weldMethod);
                    }
                    for (Class annotationType : WeldMethod.MAPPED_PARAMETER_ANNOTATIONS) {
                        if (weldMethod.getWeldParameters(annotationType).size() <= 0) continue;
                        this.declaredMethodsByAnnotatedParameters.put((Object)annotationType, weldMethod);
                    }
                }
                methodsTemp = new ArraySet(declaredMethodsTemp).trimToSize();
                if (this.superclass != null && this.superclass.getJavaClass() != Object.class) {
                    Set superClassMethods = (Set)Reflections.cast(this.superclass.getDeclaredWeldMethods());
                    methodsTemp = Sets.union(methodsTemp, (Set)superClassMethods);
                }
            }
            this.declaredMethods = new ArraySet(declaredMethodsTemp);
        } else {
            this.annotatedMethods = ArrayListMultimap.create();
            this.methodsBySignature = new HashMap();
            methodsTemp = new HashSet();
            for (AnnotatedMethod method : annotatedType.getMethods()) {
                WeldMethodImpl weldMethod = WeldMethodImpl.of(method, this, classTransformer);
                methodsTemp.add(weldMethod);
                this.methodsBySignature.put(weldMethod.getSignature(), weldMethod);
                if (method.getDeclaringType().getJavaClass() == rawType) {
                    declaredMethodsTemp.add(weldMethod);
                    this.declaredMethodsBySignature.put(weldMethod.getSignature(), weldMethod);
                }
                for (Annotation annotation : weldMethod.getAnnotations()) {
                    this.annotatedMethods.put(annotation.annotationType(), weldMethod);
                    if (method.getDeclaringType().getJavaClass() != rawType) continue;
                    this.declaredAnnotatedMethods.put(annotation.annotationType(), weldMethod);
                }
                for (Class annotationType : WeldMethod.MAPPED_PARAMETER_ANNOTATIONS) {
                    if (weldMethod.getWeldParameters(annotationType).size() <= 0 || method.getDeclaringType().getJavaClass() != rawType) continue;
                    this.declaredMethodsByAnnotatedParameters.put((Object)annotationType, weldMethod);
                }
            }
            this.declaredMethods = new ArraySet(declaredMethodsTemp);
            methodsTemp = new ArraySet(methodsTemp).trimToSize();
            this.annotatedMethods.trimToSize();
        }
        this.methods = methodsTemp;
        this.declaredMethods.trimToSize();
        this.declaredAnnotatedMethods.trimToSize();
        this.declaredMethodsByAnnotatedParameters.trimToSize();
        this.declaredMetaAnnotationMap = new ArraySetMultimap();
        for (Annotation declaredAnnotation : declaredAnnotationMap.values()) {
            WeldClassImpl.addMetaAnnotations(this.declaredMetaAnnotationMap, declaredAnnotation, declaredAnnotation.annotationType().getAnnotations(), true);
            WeldClassImpl.addMetaAnnotations(this.declaredMetaAnnotationMap, declaredAnnotation, classTransformer.getTypeStore().get(declaredAnnotation.annotationType()), true);
            this.declaredMetaAnnotationMap.putSingleElement(declaredAnnotation.annotationType(), declaredAnnotation);
        }
        this.declaredMetaAnnotationMap.trimToSize();
    }

    private <X> WeldClass<X> getDeclaringWeldClass(Member member, ClassTransformer transformer) {
        if (member.getDeclaringClass().equals(this.getJavaClass())) {
            return this;
        }
        return transformer.loadClass(member.getDeclaringClass());
    }

    public Class<? extends T> getAnnotatedClass() {
        return this.getJavaClass();
    }

    @Override
    public Class<T> getDelegate() {
        return this.getJavaClass();
    }

    @Override
    public Collection<WeldField<?, ?>> getWeldFields() {
        return Collections.unmodifiableCollection(this.fields);
    }

    public Collection<WeldField<?, ?>> getDeclaredFields() {
        return Collections.unmodifiableCollection(this.declaredFields);
    }

    @Override
    public <F> WeldField<F, ?> getDeclaredWeldField(String fieldName) {
        return this.declaredFieldsByName.get(fieldName);
    }

    @Override
    public Collection<WeldField<?, ? super T>> getDeclaredWeldFields(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableCollection(this.declaredAnnotatedFields.get(annotationType));
    }

    @Override
    public WeldConstructor<T> getDeclaredWeldConstructor(ConstructorSignature signature) {
        return this.declaredConstructorsBySignature.get(signature);
    }

    @Override
    public Collection<WeldField<?, ?>> getWeldFields(Class<? extends Annotation> annotationType) {
        if (this.annotatedFields == null) {
            ArrayList aggregatedFields = new ArrayList(this.declaredAnnotatedFields.get(annotationType));
            if (this.superclass != null && this.superclass.getJavaClass() != Object.class) {
                aggregatedFields.addAll(this.superclass.getWeldFields(annotationType));
            }
            return Collections.unmodifiableCollection(aggregatedFields);
        }
        return Collections.unmodifiableCollection(this.annotatedFields.get(annotationType));
    }

    @Override
    public boolean isLocalClass() {
        return this.getJavaClass().isLocalClass();
    }

    @Override
    public boolean isAnonymousClass() {
        return this.getJavaClass().isAnonymousClass();
    }

    @Override
    public boolean isMemberClass() {
        return this.getJavaClass().isMemberClass();
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.getJavaClass().getModifiers());
    }

    @Override
    public boolean isEnum() {
        return this.getJavaClass().isEnum();
    }

    @Override
    public boolean isSerializable() {
        return Reflections.isSerializable(this.getJavaClass());
    }

    @Override
    public Collection<WeldMethod<?, ?>> getWeldMethods(Class<? extends Annotation> annotationType) {
        if (this.annotatedMethods == null) {
            ArrayList aggregateMethods = new ArrayList(this.declaredAnnotatedMethods.get(annotationType));
            if (this.superclass != null && this.superclass.getJavaClass() != Object.class) {
                aggregateMethods.addAll(this.superclass.getDeclaredWeldMethods(annotationType));
            }
            return Collections.unmodifiableCollection(aggregateMethods);
        }
        return Collections.unmodifiableCollection(this.annotatedMethods.get(annotationType));
    }

    @Override
    public Collection<WeldMethod<?, ? super T>> getDeclaredWeldMethods(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableCollection(this.declaredAnnotatedMethods.get(annotationType));
    }

    @Override
    public Collection<WeldConstructor<T>> getWeldConstructors(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableCollection(this.annotatedConstructors.get(annotationType));
    }

    @Override
    public WeldConstructor<T> getNoArgsWeldConstructor() {
        return this.constructorsByArgumentMap.get(Collections.emptyList());
    }

    @Override
    public Collection<WeldMethod<?, ? super T>> getDeclaredWeldMethodsWithAnnotatedParameters(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableCollection(this.declaredMethodsByAnnotatedParameters.get(annotationType));
    }

    @Override
    public WeldMethod<?, ?> getWeldMethod(Method methodDescriptor) {
        for (WeldMethod<?, T> annotatedMethod : this.getWeldMethods()) {
            if (!annotatedMethod.getName().equals(methodDescriptor.getName()) || !Arrays.equals(annotatedMethod.getParameterTypesAsArray(), methodDescriptor.getParameterTypes())) continue;
            return annotatedMethod;
        }
        return null;
    }

    @Override
    public Collection<WeldMethod<?, ? super T>> getWeldMethods() {
        return Collections.unmodifiableSet(this.methods);
    }

    @Override
    public WeldMethod<?, ?> getDeclaredWeldMethod(Method method) {
        for (WeldMethod<?, T> annotatedMethod : this.declaredMethods) {
            if (!annotatedMethod.getName().equals(method.getName()) || !Arrays.equals(annotatedMethod.getParameterTypesAsArray(), method.getParameterTypes())) continue;
            return annotatedMethod;
        }
        return null;
    }

    @Override
    public Collection<WeldMethod<?, ? super T>> getDeclaredWeldMethods() {
        return Collections.unmodifiableSet(this.declaredMethods);
    }

    @Override
    public <M> WeldMethod<M, ?> getDeclaredWeldMethod(MethodSignature signature) {
        return this.declaredMethodsBySignature.get(signature);
    }

    @Override
    public <M> WeldMethod<M, ?> getWeldMethod(MethodSignature signature) {
        if (this.methodsBySignature == null) {
            WeldMethod<Object, ?> method = this.declaredMethodsBySignature.get(signature);
            if (method == null && this.superclass != null && this.superclass.getJavaClass() != Object.class) {
                method = this.superclass.getWeldMethod(signature);
            }
            return method;
        }
        return this.methodsBySignature.get(signature);
    }

    public String toString() {
        return Formats.formatModifiers(this.getJavaClass().getModifiers()) + Formats.formatAnnotations(this.getAnnotations()) + " class " + this.getName() + Formats.formatActualTypeArguments(this.getActualTypeArguments());
    }

    @Override
    public String getSimpleName() {
        return this.getJavaClass().getSimpleName();
    }

    @Override
    public boolean isStatic() {
        return Reflections.isStatic(this.getDelegate());
    }

    @Override
    public boolean isFinal() {
        return Reflections.isFinal(this.getDelegate());
    }

    @Override
    public boolean isPublic() {
        return Modifier.isFinal(this.getJavaClass().getModifiers());
    }

    @Override
    public boolean isGeneric() {
        return this.getJavaClass().getTypeParameters().length > 0;
    }

    @Override
    public String getName() {
        return this.getJavaClass().getName();
    }

    @Override
    public WeldClass<? super T> getWeldSuperclass() {
        return this.superclass;
    }

    @Override
    public boolean isEquivalent(Class<?> clazz) {
        return this.getDelegate().equals(clazz);
    }

    @Override
    public boolean isPrivate() {
        return Modifier.isPrivate(this.getJavaClass().getModifiers());
    }

    @Override
    public boolean isPackagePrivate() {
        return Reflections.isPackagePrivate(this.getJavaClass().getModifiers());
    }

    @Override
    public Package getPackage() {
        return this.getJavaClass().getPackage();
    }

    @Override
    public <U> WeldClass<? extends U> asWeldSubclass(WeldClass<U> clazz) {
        return this;
    }

    @Override
    public <S> S cast(Object object) {
        return (S)object;
    }

    public Set<AnnotatedConstructor<T>> getConstructors() {
        return Collections.unmodifiableSet(new ArraySet<AnnotatedConstructor<T>>(this.constructors));
    }

    public Set<AnnotatedField<? super T>> getFields() {
        return this.fields;
    }

    public Set<AnnotatedMethod<? super T>> getMethods() {
        return this.methods;
    }

    public Set<Annotation> getDeclaredMetaAnnotations(Class<? extends Annotation> metaAnnotationType) {
        return Collections.unmodifiableSet(new ArraySet(this.declaredMetaAnnotationMap.get(metaAnnotationType)));
    }

    @Override
    public boolean isDiscovered() {
        return this.discovered;
    }
}

