/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.resolution.TypeSafeResolver;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSafeBeanResolver<T extends Bean<?>>
extends TypeSafeResolver<Resolvable, T> {
    private final BeanManagerImpl beanManager;
    private final ConcurrentMap<Set<Bean<?>>, Set<Bean<?>>> disambiguatedBeans;

    public TypeSafeBeanResolver(BeanManagerImpl beanManager, Iterable<T> beans) {
        super(beans);
        this.beanManager = beanManager;
        this.disambiguatedBeans = new MapMaker().makeComputingMap((Function)new BeanDisambiguation());
    }

    @Override
    protected boolean matches(Resolvable resolvable, T bean) {
        return Reflections.matches(resolvable.getTypes(), bean.getTypes()) && Beans.containsAllQualifiers(resolvable.getQualifiers(), bean.getQualifiers(), this.beanManager);
    }

    protected BeanManagerImpl getBeanManager() {
        return this.beanManager;
    }

    @Override
    protected Set<T> filterResult(Set<T> matched) {
        return Beans.removeDisabledAndSpecializedBeans(matched, this.beanManager);
    }

    @Override
    protected Set<T> sortResult(Set<T> matched) {
        return matched;
    }

    @Override
    public <X> Set<Bean<? extends X>> resolve(Set<Bean<? extends X>> beans) {
        beans = new HashSet<Bean<X>>(beans);
        return (Set)Reflections.cast(Collections.unmodifiableSet((Set)this.disambiguatedBeans.get(beans)));
    }

    @Override
    public void clear() {
        super.clear();
        this.disambiguatedBeans.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BeanDisambiguation
    implements Function<Set<Bean<?>>, Set<Bean<?>>> {
        private BeanDisambiguation() {
        }

        public Set<Bean<?>> apply(Set<Bean<?>> from) {
            if (from.size() > 1) {
                boolean alternativePresent = Beans.isAlternativePresent(from);
                HashSet disambiguatedBeans = new HashSet();
                for (Bean<?> bean : from) {
                    if (alternativePresent && !bean.isAlternative()) continue;
                    disambiguatedBeans.add(bean);
                }
                return disambiguatedBeans;
            }
            return from;
        }
    }
}

