/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.enterprise.inject.spi.BeanManager;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.Filter;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.messages.XmlMessage;
import org.jboss.weld.metadata.BeansXmlImpl;
import org.jboss.weld.metadata.ScanningImpl;
import org.jboss.weld.xml.BeansXmlHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeansXmlParser {
    private static final InputSource[] EMPTY_INPUT_SOURCE_ARRAY = new InputSource[0];

    public BeansXml parse(URL beansXml) {
        SAXParser parser;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(true);
        if (beansXml == null) {
            throw new IllegalStateException(XmlMessage.LOAD_ERROR, "unknown");
        }
        try {
            parser = factory.newSAXParser();
        }
        catch (SAXException e) {
            throw new IllegalStateException(XmlMessage.CONFIGURATION_ERROR, (Throwable)e, new Object[0]);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(XmlMessage.CONFIGURATION_ERROR, (Throwable)e, new Object[0]);
        }
        try {
            InputSource source = new InputSource(beansXml.openStream());
            if (source.getByteStream().available() == 0) {
                return BeansXml.EMPTY_BEANS_XML;
            }
            BeansXmlHandler handler = new BeansXmlHandler(beansXml);
            try {
                parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", BeansXmlParser.loadXsds());
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            parser.parse(source, (DefaultHandler)handler);
            return handler.createBeansXml();
        }
        catch (IOException e) {
            throw new IllegalStateException(XmlMessage.LOAD_ERROR, (Throwable)e, beansXml);
        }
        catch (SAXException e) {
            throw new IllegalStateException(XmlMessage.PARSING_ERROR, beansXml, e);
        }
    }

    public BeansXml parse(Iterable<URL> urls) {
        ArrayList<Metadata<String>> alternativeStereotypes = new ArrayList<Metadata<String>>();
        ArrayList<Metadata<String>> alternativeClasses = new ArrayList<Metadata<String>>();
        ArrayList<Metadata<String>> decorators = new ArrayList<Metadata<String>>();
        ArrayList<Metadata<String>> interceptors = new ArrayList<Metadata<String>>();
        ArrayList<Metadata<Filter>> includes = new ArrayList<Metadata<Filter>>();
        ArrayList<Metadata<Filter>> excludes = new ArrayList<Metadata<Filter>>();
        for (URL url : urls) {
            BeansXml beansXml = this.parse(url);
            alternativeStereotypes.addAll(beansXml.getEnabledAlternativeStereotypes());
            alternativeClasses.addAll(beansXml.getEnabledAlternativeClasses());
            decorators.addAll(beansXml.getEnabledDecorators());
            interceptors.addAll(beansXml.getEnabledInterceptors());
            includes.addAll(beansXml.getScanning().getIncludes());
            excludes.addAll(beansXml.getScanning().getExcludes());
        }
        return new BeansXmlImpl(alternativeClasses, alternativeStereotypes, decorators, interceptors, new ScanningImpl(includes, excludes));
    }

    private static InputSource[] loadXsds() {
        ArrayList<InputSource> xsds = new ArrayList<InputSource>();
        InputSource weldXsd = BeansXmlParser.loadXsd("beans_1_1.xsd", BeansXmlParser.class.getClassLoader());
        InputSource cdiXsd = BeansXmlParser.loadXsd("beans_1_0.xsd", BeanManager.class.getClassLoader());
        if (weldXsd != null) {
            xsds.add(weldXsd);
        }
        if (cdiXsd != null) {
            xsds.add(cdiXsd);
        }
        return xsds.toArray(EMPTY_INPUT_SOURCE_ARRAY);
    }

    private static InputSource loadXsd(String name, ClassLoader classLoader) {
        InputStream in = classLoader.getResourceAsStream(name);
        if (in == null) {
            return null;
        }
        return new InputSource(in);
    }
}

