/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.transaction;

import com.arjuna.ats.jbossatx.jta.TransactionManagerService;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.jboss.weld.transaction.spi.TransactionServices;

public class JBossTransactionServices
implements TransactionServices {
    private final TransactionManagerService transactionManager;

    public JBossTransactionServices(TransactionManagerService transactionManager) {
        this.transactionManager = transactionManager;
    }

    public boolean isTransactionActive() {
        try {
            return this.getUserTransaction().getStatus() == 0;
        }
        catch (SystemException e) {
            throw new RuntimeException("Failed to determine transaction status", e);
        }
    }

    public TransactionManagerService getTransactionManager() {
        return this.transactionManager;
    }

    public void registerSynchronization(Synchronization synchronizedObserver) {
        try {
            this.getTransactionManager().getTransactionManager().getTransaction().registerSynchronization(synchronizedObserver);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to register synchronization " + synchronizedObserver + " for current transaction", e);
        }
    }

    public UserTransaction getUserTransaction() {
        return this.transactionManager.getUserTransaction();
    }

    public void cleanup() {
    }
}

