/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.mc;

import javax.enterprise.inject.spi.BeanManager;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.weld.plugins.dependency.WeldKernelControllerContext;
import org.jboss.logging.Logger;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.integration.deployer.env.helpers.BootstrapBean;
import org.jboss.weld.integration.deployer.mc.BeanMetaDataPropertyHolder;
import org.jboss.weld.integration.deployer.mc.WeldBeanMetaDataDeployerPlugin;
import org.jboss.weld.manager.api.WeldManager;

public class IntermediateWeldBootstrapBean {
    static final Logger log = Logger.getLogger((String)IntermediateWeldBootstrapBean.class.getName());
    private BootstrapBean bootstrapBean;
    private Deployment deployment;
    private BeanMetaDataPropertyHolder beanMetaDataHolder;
    private ControllerContext context;
    private WeldBeanMetaDataDeployerPlugin creator;

    public BootstrapBean getBootstrapBean() {
        return this.bootstrapBean;
    }

    public void setBootstrapBean(BootstrapBean bootstrapBean) {
        this.bootstrapBean = bootstrapBean;
    }

    public Deployment getDeployment() {
        return this.deployment;
    }

    public void setDeployment(Deployment deployment) {
        this.deployment = deployment;
    }

    public ControllerContext getContext() {
        return this.context;
    }

    public void setContext(ControllerContext context) {
        this.context = context;
    }

    public BeanMetaDataPropertyHolder getBeanMetaDataHolder() {
        return this.beanMetaDataHolder;
    }

    public void setBeanMetaDataHolder(BeanMetaDataPropertyHolder beanMetaDataHolder) {
        this.beanMetaDataHolder = beanMetaDataHolder;
    }

    public WeldBeanMetaDataDeployerPlugin getCreator() {
        return this.creator;
    }

    public void setCreator(WeldBeanMetaDataDeployerPlugin creator) {
        this.creator = creator;
    }

    public void create() throws Exception {
        WeldManager manager;
        if (this.bootstrapBean == null) {
            throw new IllegalStateException("Null bootstrap bean");
        }
        if (this.beanMetaDataHolder == null) {
            throw new IllegalStateException("Null bean metadata");
        }
        if (this.context == null) {
            throw new IllegalStateException("Null context");
        }
        if (this.deployment == null) {
            throw new IllegalStateException("Null deployment");
        }
        if (this.deployment.getBeanDeploymentArchives().size() == 0) {
            throw new IllegalStateException("Zero bean deployment archives in the deployment");
        }
        BeanDeploymentArchive archive = (BeanDeploymentArchive)this.deployment.getBeanDeploymentArchives().iterator().next();
        if (this.deployment.getBeanDeploymentArchives().size() > 1) {
            log.warn((Object)("More than one bean deployment archives, using the first " + archive));
        }
        if ((manager = this.bootstrapBean.getBootstrap().getManager(archive)) == null) {
            throw new IllegalStateException("Could not find a manager for archive " + null);
        }
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((BeanMetaData)this.beanMetaDataHolder.getBeanMetaData());
        builder.addInstallWithParameters("installCreatedBean", (String)this.context.getName(), ControllerState.INSTALLED);
        WeldKernelControllerContext ctx = new WeldKernelControllerContext(null, this.beanMetaDataHolder.getBeanMetaData(), null, (BeanManager)manager);
        try {
            this.context.getController().install((ControllerContext)ctx);
        }
        catch (Throwable t) {
            throw new Exception(t);
        }
        this.creator.removeIntermediateBean(this.beanMetaDataHolder.getBeanMetaData().getName());
    }

    public void installCreatedBean() {
        this.context.getController().uninstall(this.context.getName());
    }
}

