package org.jboss.weld.integration.deployer.cl;


import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.weld.integration.deployer.DeployersUtils;

/**
 * Weld integration deployer.
 *
 * @author <a href="mailto:ales.justin@jboss.com">Ales Justin</a>
 * @author Pete Muir
 */
public class WeldFacesIntegrationDeployer extends WeldUrlIntegrationDeployer<JBossWebMetaData>
{
   public WeldFacesIntegrationDeployer()
   {
      super(JBossWebMetaData.class);
      // We do this at top level to ensure that any deployment (ear or war)
      // that supports WB gets this integration (even if that particular war doesn't have beans.xml)
      setTopLevelOnly(true);
      setInputs(DeployersUtils.WELD_FILES);
      setIntegrationURLs(getURLs());
   }

   @Override // we override this, as we want any beans.xml
   protected boolean isIntegrationDeployment(VFSDeploymentUnit unit)
   {
      return DeployersUtils.checkForWeldFiles(unit);
   }

   @Override
   protected String getShortLibName()
   {
      return "faces";
   }
}