package org.jboss.weld.integration.deployer.cl;


import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;

import org.jboss.deployers.vfs.plugins.classloader.PathUrlIntegrationDeployer;
import org.jboss.util.StringPropertyReplacer;

/**
 * Web Beans RI integration deployer.
 *
 * @param <T> exact input type
 * @author <a href="mailto:ales.justin@jboss.com">Ales Justin</a>
 */
public abstract class WeldUrlIntegrationDeployer<T> extends PathUrlIntegrationDeployer<T>
{
   protected WeldUrlIntegrationDeployer(Class<T> input)
   {
      super(input);
      setIntegrationURLs(getURLs());
   }

   /**
    * Get the short name.
    * @return
    */
   protected abstract String getShortLibName();

   /**
    * Get the Weld core integration urls.
    *
    * @return the weld jbossas integration urls
    */
   protected Set<URL> getURLs()
   {
      try
      {
         String libOpt = getServerHome() + getOptionalLib();
         libOpt = StringPropertyReplacer.replaceProperties(libOpt);
         return Collections.singleton(new URL(libOpt + getShortLibName()));
      }
      catch (MalformedURLException e)
      {
         throw new IllegalArgumentException("Unexpected error: " + e);
      }
   }

   /**
    * Get server home.
    *
    * @return the jboss server home location
    */
   protected String getServerHome()
   {
      return "${jboss.server.home.url}";
   }

   /**
    * Get the optinal lib path.
    *
    * @return the integration path
    */
   protected String getOptionalLib()
   {
      return "deployers/weld.deployer/lib-int/";
   }
}