package org.jboss.weld.integration.deployer.env;

import java.util.ArrayList;
import java.util.List;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.weld.integration.deployer.DeployersUtils;

/**
 * Ensures that Weld is bootstrapped before the Web Application is started
 * (if this is a CDI-enabled deployment)
 *
 * @author Marius Bogoevici
 * @author Ales Justin
 */
public class WebContainerDependencyDeployer extends AbstractSimpleRealDeployer<JBossWebMetaData>
{
   public WebContainerDependencyDeployer()
   {
      super(JBossWebMetaData.class);
      setOutput(JBossWebMetaData.class);
   }

   @Override
   public void deploy(DeploymentUnit unit, JBossWebMetaData deployment) throws DeploymentException
   {
      if (DeployersUtils.isBootstrapBeanPresent(unit))
      {
         List<String> depends = deployment.getDepends();
         if (depends == null)
         {
            depends = new ArrayList<String>();
            deployment.setDepends(depends);
         }
         depends.add(DeployersUtils.getBootstrapBeanName(unit));
      }
   }
}
