package org.jboss.weld.integration.deployer.cl;


import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.weld.integration.deployer.DeployersUtils;
import org.jboss.weld.integration.deployer.ext.JBossWeldMetaData;

/**
 * Web Beans RI core integration deployer.
 *
 * @author <a href="mailto:ales.justin@jboss.com">Ales Justin</a>
 */
public class WeldCoreIntegrationDeployer extends WeldUrlIntegrationDeployer<JBossWeldMetaData>
{
   public WeldCoreIntegrationDeployer()
   {
      super(JBossWeldMetaData.class);
      setTopLevelOnly(true); // only top level, as that's where Bootstrap bean is gonna be
      setInputs(DeployersUtils.WELD_FILES);
      setIntegrationURLs(getURLs());
   }

   @Override // we override this, as we want any beans.xml
   protected boolean isIntegrationDeployment(VFSDeploymentUnit unit)
   {
      return DeployersUtils.checkForWeldFilesInUnitAndChildren(unit);
   }

   @Override
   protected String getShortLibName()
   {
      return "weld-core.jar";
   }
}